/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CEnumerator
extends PlatformObject
implements IEnumerator {
    private final IASTName enumeratorName;

    public CEnumerator(IASTEnumerationSpecifier.IASTEnumerator enumtor) {
        this.enumeratorName = enumtor.getName();
        this.enumeratorName.setBinding(this);
    }

    public IASTNode getPhysicalNode() {
        return this.enumeratorName;
    }

    @Override
    public String getName() {
        return this.enumeratorName.toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.enumeratorName.toCharArray();
    }

    @Override
    public IScope getScope() {
        return CVisitor.getContainingScope(this.enumeratorName.getParent());
    }

    @Override
    public IType getType() {
        return (IType)((Object)this.getOwner());
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        IASTEnumerationSpecifier.IASTEnumerator etor = (IASTEnumerationSpecifier.IASTEnumerator)this.enumeratorName.getParent();
        IASTEnumerationSpecifier enumSpec = (IASTEnumerationSpecifier)etor.getParent();
        return enumSpec.getName().resolveBinding();
    }

    @Override
    public IValue getValue() {
        IASTNode parent = this.enumeratorName.getParent();
        if (parent instanceof ASTEnumerator) {
            return ((ASTEnumerator)parent).getIntegralValue();
        }
        return IntegralValue.UNKNOWN;
    }

    public String toString() {
        return this.getName();
    }

    public static class CEnumeratorProblem
    extends ProblemBinding
    implements IEnumerator {
        public CEnumeratorProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        @Override
        public IValue getValue() {
            return IntegralValue.UNKNOWN;
        }
    }
}

