/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.handlers;

import com.github.badsyntax.gradle.ErrorMessageBuilder;
import com.github.badsyntax.gradle.ExecuteCommandReply;
import com.github.badsyntax.gradle.ExecuteCommandRequest;
import com.github.badsyntax.gradle.utils.Utils;
import com.google.protobuf.ProtocolStringList;
import io.grpc.stub.StreamObserver;

public class ExecuteCommandHandler {
    private ExecuteCommandRequest req;
    private StreamObserver<ExecuteCommandReply> responseObserver;
    private static final String GET_NORMALIZED_PACKAGE_NAME = "getNormalizedPackageName";

    public ExecuteCommandHandler(ExecuteCommandRequest req, StreamObserver<ExecuteCommandReply> responseObserver) {
        this.req = req;
        this.responseObserver = responseObserver;
    }

    public void run() {
        String command;
        switch (command = this.req.getCommand()) {
            case "getNormalizedPackageName": {
                ProtocolStringList arguments = this.req.getArgumentsList();
                if (arguments == null || arguments.size() != 1) {
                    this.replyWithError(new Exception("illegal Arguments"));
                }
                try {
                    this.replyWithSuccess(Utils.normalizePackageName((String)arguments.get(0)));
                    break;
                }
                catch (Exception e) {
                    this.replyWithError(e);
                }
            }
        }
    }

    private void replyWithError(Exception e) {
        this.responseObserver.onError((Throwable)ErrorMessageBuilder.build(e));
    }

    private void replyWithSuccess(String value) {
        this.responseObserver.onNext((Object)ExecuteCommandReply.newBuilder().setResult(value).build());
        this.responseObserver.onCompleted();
    }
}

