/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import java.util.Map;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import org.commonmark.node.Node;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class TableHtmlNodeRenderer
extends TableNodeRenderer {
    private final HtmlWriter htmlWriter;
    private final HtmlNodeRendererContext context;

    public TableHtmlNodeRenderer(HtmlNodeRendererContext context) {
        this.htmlWriter = context.getWriter();
        this.context = context;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.htmlWriter.line();
        this.htmlWriter.tag("table", this.getAttributes((Node)tableBlock, "table"));
        this.renderChildren((Node)tableBlock);
        this.htmlWriter.tag("/table");
        this.htmlWriter.line();
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.htmlWriter.line();
        this.htmlWriter.tag("thead", this.getAttributes((Node)tableHead, "thead"));
        this.renderChildren((Node)tableHead);
        this.htmlWriter.tag("/thead");
        this.htmlWriter.line();
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tbody", this.getAttributes((Node)tableBody, "tbody"));
        this.renderChildren((Node)tableBody);
        this.htmlWriter.tag("/tbody");
        this.htmlWriter.line();
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tr", this.getAttributes((Node)tableRow, "tr"));
        this.renderChildren((Node)tableRow);
        this.htmlWriter.tag("/tr");
        this.htmlWriter.line();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        String tagName = tableCell.isHeader() ? "th" : "td";
        this.htmlWriter.line();
        this.htmlWriter.tag(tagName, this.getCellAttributes(tableCell, tagName));
        this.renderChildren((Node)tableCell);
        this.htmlWriter.tag("/" + tagName);
        this.htmlWriter.line();
    }

    private Map<String, String> getAttributes(Node node, String tagName) {
        return this.context.extendAttributes(node, tagName, Map.of());
    }

    private Map<String, String> getCellAttributes(TableCell tableCell, String tagName) {
        if (tableCell.getAlignment() != null) {
            return this.context.extendAttributes((Node)tableCell, tagName, Map.of("align", TableHtmlNodeRenderer.getAlignValue(tableCell.getAlignment())));
        }
        return this.context.extendAttributes((Node)tableCell, tagName, Map.of());
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + String.valueOf((Object)alignment));
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

