/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.FDBigInteger;

public class FloatingDecimal {
    static final int EXP_SHIFT = 52;
    static final long FRACT_HOB = 0x10000000000000L;
    static final long EXP_ONE = 0x3FF0000000000000L;
    static final int MAX_SMALL_BIN_EXP = 62;
    static final int MIN_SMALL_BIN_EXP = -21;
    static final int MAX_DECIMAL_DIGITS = 15;
    static final int MAX_DECIMAL_EXPONENT = 308;
    static final int MIN_DECIMAL_EXPONENT = -324;
    static final int BIG_DECIMAL_EXPONENT = 324;
    static final int MAX_NDIGITS = 1100;
    static final int SINGLE_EXP_SHIFT = 23;
    static final int SINGLE_FRACT_HOB = 0x800000;
    static final int SINGLE_MAX_DECIMAL_DIGITS = 7;
    static final int SINGLE_MAX_DECIMAL_EXPONENT = 38;
    static final int SINGLE_MIN_DECIMAL_EXPONENT = -45;
    static final int SINGLE_MAX_NDIGITS = 200;
    static final int INT_DECIMAL_DIGITS = 9;
    private static final String INFINITY_REP = "Infinity";
    private static final int INFINITY_LENGTH = "Infinity".length();
    private static final String NAN_REP = "NaN";
    private static final int NAN_LENGTH = "NaN".length();
    private static final BinaryToASCIIConverter B2AC_POSITIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("Infinity", false);
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("-Infinity", true);
    private static final BinaryToASCIIConverter B2AC_NOT_A_NUMBER = new ExceptionalBinaryToASCIIBuffer("NaN", false);
    private static final BinaryToASCIIConverter B2AC_POSITIVE_ZERO = new BinaryToASCIIBuffer(false, new char[]{'0'});
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_ZERO = new BinaryToASCIIBuffer(true, new char[]{'0'});
    private static final ThreadLocal<BinaryToASCIIBuffer> threadLocalBinaryToASCIIBuffer = new ThreadLocal<BinaryToASCIIBuffer>(){

        @Override
        protected BinaryToASCIIBuffer initialValue() {
            return new BinaryToASCIIBuffer();
        }
    };
    static final ASCIIToBinaryConverter A2BC_POSITIVE_INFINITY = new PreparedASCIIToBinaryBuffer(Double.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
    static final ASCIIToBinaryConverter A2BC_NEGATIVE_INFINITY = new PreparedASCIIToBinaryBuffer(Double.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    static final ASCIIToBinaryConverter A2BC_NOT_A_NUMBER = new PreparedASCIIToBinaryBuffer(Double.NaN, Float.NaN);
    static final ASCIIToBinaryConverter A2BC_POSITIVE_ZERO = new PreparedASCIIToBinaryBuffer(0.0, 0.0f);
    static final ASCIIToBinaryConverter A2BC_NEGATIVE_ZERO = new PreparedASCIIToBinaryBuffer(-0.0, -0.0f);

    public static String toJavaFormatString(double d) {
        return FloatingDecimal.getBinaryToASCIIConverter(d).toJavaFormatString();
    }

    public static String toJavaFormatString(float f) {
        return FloatingDecimal.getBinaryToASCIIConverter(f).toJavaFormatString();
    }

    public static void appendTo(double d, Appendable appendable) {
        FloatingDecimal.getBinaryToASCIIConverter(d).appendTo(appendable);
    }

    public static void appendTo(float f, Appendable appendable) {
        FloatingDecimal.getBinaryToASCIIConverter(f).appendTo(appendable);
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).doubleValue();
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).floatValue();
    }

    private static BinaryToASCIIBuffer getBinaryToASCIIBuffer() {
        return threadLocalBinaryToASCIIBuffer.get();
    }

    public static BinaryToASCIIConverter getBinaryToASCIIConverter(double d) {
        return FloatingDecimal.getBinaryToASCIIConverter(d, true);
    }

    static BinaryToASCIIConverter getBinaryToASCIIConverter(double d, boolean bl) {
        int n;
        long l = Double.doubleToRawLongBits(d);
        boolean bl2 = (l & Long.MIN_VALUE) != 0L;
        long l2 = l & 0xFFFFFFFFFFFFFL;
        int n2 = (int)((l & 0x7FF0000000000000L) >> 52);
        if (n2 == 2047) {
            if (l2 == 0L) {
                return bl2 ? B2AC_NEGATIVE_INFINITY : B2AC_POSITIVE_INFINITY;
            }
            return B2AC_NOT_A_NUMBER;
        }
        if (n2 == 0) {
            if (l2 == 0L) {
                return bl2 ? B2AC_NEGATIVE_ZERO : B2AC_POSITIVE_ZERO;
            }
            int n3 = Long.numberOfLeadingZeros(l2);
            int n4 = n3 - 11;
            l2 <<= n4;
            n2 = 1 - n4;
            n = 64 - n3;
        } else {
            l2 |= 0x10000000000000L;
            n = 53;
        }
        BinaryToASCIIBuffer binaryToASCIIBuffer = FloatingDecimal.getBinaryToASCIIBuffer();
        binaryToASCIIBuffer.setSign(bl2);
        binaryToASCIIBuffer.dtoa(n2 -= 1023, l2, n, bl);
        return binaryToASCIIBuffer;
    }

    private static BinaryToASCIIConverter getBinaryToASCIIConverter(float f) {
        int n;
        int n2 = Float.floatToRawIntBits(f);
        boolean bl = (n2 & Integer.MIN_VALUE) != 0;
        int n3 = n2 & 0x7FFFFF;
        int n4 = (n2 & 0x7F800000) >> 23;
        if (n4 == 255) {
            if ((long)n3 == 0L) {
                return bl ? B2AC_NEGATIVE_INFINITY : B2AC_POSITIVE_INFINITY;
            }
            return B2AC_NOT_A_NUMBER;
        }
        if (n4 == 0) {
            if (n3 == 0) {
                return bl ? B2AC_NEGATIVE_ZERO : B2AC_POSITIVE_ZERO;
            }
            int n5 = Integer.numberOfLeadingZeros(n3);
            int n6 = n5 - 8;
            n3 <<= n6;
            n4 = 1 - n6;
            n = 32 - n5;
        } else {
            n3 |= 0x800000;
            n = 24;
        }
        BinaryToASCIIBuffer binaryToASCIIBuffer = FloatingDecimal.getBinaryToASCIIBuffer();
        binaryToASCIIBuffer.setSign(bl);
        binaryToASCIIBuffer.dtoa(n4 -= 127, (long)n3 << 29, n, true);
        return binaryToASCIIBuffer;
    }

    static ASCIIToBinaryConverter readJavaFormatString(String string) throws NumberFormatException {
        block35: {
            boolean bl = false;
            boolean bl2 = false;
            try {
                boolean bl3;
                char c;
                string = string.trim();
                int n = string.length();
                if (n == 0) {
                    throw new NumberFormatException("empty String");
                }
                int n2 = 0;
                switch (string.charAt(n2)) {
                    case '-': {
                        bl = true;
                    }
                    case '+': {
                        ++n2;
                        bl2 = true;
                    }
                }
                char c2 = string.charAt(n2);
                if (c2 == 'N') {
                    if (n - n2 == NAN_LENGTH && string.indexOf(NAN_REP, n2) == n2) {
                        return A2BC_NOT_A_NUMBER;
                    }
                    break block35;
                }
                if (c2 == 'I') {
                    if (n - n2 == INFINITY_LENGTH && string.indexOf(INFINITY_REP, n2) == n2) {
                        return bl ? A2BC_NEGATIVE_INFINITY : A2BC_POSITIVE_INFINITY;
                    }
                    break block35;
                }
                if (c2 == '0' && n > n2 + 1 && ((c = string.charAt(n2 + 1)) == 'x' || c == 'X')) {
                    return FloatingDecimal.parseHexString(string);
                }
                char[] cArray = new char[n];
                int n3 = 0;
                boolean bl4 = false;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (n2 < n) {
                    c2 = string.charAt(n2);
                    if (c2 == '0') {
                        ++n5;
                    } else {
                        if (c2 != '.') break;
                        if (bl4) {
                            throw new NumberFormatException("multiple points");
                        }
                        n4 = n2;
                        if (bl2) {
                            --n4;
                        }
                        bl4 = true;
                    }
                    ++n2;
                }
                while (n2 < n) {
                    c2 = string.charAt(n2);
                    if (c2 >= '1' && c2 <= '9') {
                        cArray[n3++] = c2;
                        n6 = 0;
                    } else if (c2 == '0') {
                        cArray[n3++] = c2;
                        ++n6;
                    } else {
                        if (c2 != '.') break;
                        if (bl4) {
                            throw new NumberFormatException("multiple points");
                        }
                        n4 = n2;
                        if (bl2) {
                            --n4;
                        }
                        bl4 = true;
                    }
                    ++n2;
                }
                boolean bl5 = bl3 = (n3 -= n6) == 0;
                if (bl3 && n5 == 0) break block35;
                int n7 = bl4 ? n4 - n5 : n3 + n6;
                if (n2 < n && ((c2 = string.charAt(n2)) == 'e' || c2 == 'E')) {
                    int n8 = 1;
                    int n9 = 0;
                    int n10 = 0xCCCCCCC;
                    boolean bl6 = false;
                    switch (string.charAt(++n2)) {
                        case '-': {
                            n8 = -1;
                        }
                        case '+': {
                            ++n2;
                        }
                    }
                    int n11 = n2;
                    while (n2 < n) {
                        if (n9 >= n10) {
                            bl6 = true;
                        }
                        if ((c2 = string.charAt(n2++)) >= '0' && c2 <= '9') {
                            n9 = n9 * 10 + (c2 - 48);
                            continue;
                        }
                        --n2;
                        break;
                    }
                    int n12 = 324 + n3 + n6;
                    n7 = bl6 || n9 > n12 ? n8 * n12 : (n7 += n8 * n9);
                    if (n2 == n11) break block35;
                }
                if (n2 >= n || n2 == n - 1 && (string.charAt(n2) == 'f' || string.charAt(n2) == 'F' || string.charAt(n2) == 'd' || string.charAt(n2) == 'D')) {
                    if (bl3) {
                        return bl ? A2BC_NEGATIVE_ZERO : A2BC_POSITIVE_ZERO;
                    }
                    return new ASCIIToBinaryBuffer(bl, n7, cArray, n3);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + string + "\"");
    }

    static ASCIIToBinaryConverter parseHexString(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        long l;
        long l2;
        Matcher matcher = HexFloatPattern.VALUE.matcher(string);
        boolean bl = matcher.matches();
        if (!bl) {
            throw new NumberFormatException("For input string: \"" + string + "\"");
        }
        String string2 = matcher.group(1);
        boolean bl2 = string2 != null && string2.equals("-");
        String string3 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string4 = matcher.group(4);
        if (string4 != null) {
            string3 = FloatingDecimal.stripLeadingZeros(string4);
            n7 = string3.length();
        } else {
            String string5 = FloatingDecimal.stripLeadingZeros(matcher.group(6));
            n7 = string5.length();
            String string6 = matcher.group(7);
            n8 = string6.length();
            string3 = (string5 == null ? "" : string5) + string6;
        }
        string3 = FloatingDecimal.stripLeadingZeros(string3);
        n5 = string3.length();
        n6 = n7 >= 1 ? 4 