/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.context;

import com.google.common.base.Strings;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.internal.model.iface.TaskingItem;
import org.osgi.service.component.annotations.Component;

@Component(service={IContextFunction.class}, property={"service.context.key=org.eclipse.tea.core.services.TaskChain"})
public class TaskChainLookupContextFunction
extends ContextFunction {
    public Object compute(IEclipseContext context, String contextKey) {
        String taskChainName = (String)context.get("org.eclipse.tea.core.taskchain");
        if (Strings.isNullOrEmpty((String)taskChainName)) {
            return IInjector.NOT_A_VALUE;
        }
        TaskingModel model = (TaskingModel)ContextInjectionFactory.make(TaskingModel.class, (IEclipseContext)context);
        TaskingItem lookup = model.getRootGroup().getItem(taskChainName);
        if (lookup == null) {
            throw new IllegalArgumentException("cannot find task chain named: " + taskChainName);
        }
        return lookup.getChain();
    }
}

