/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.dialog;

import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SiriusMessageDialogWithToggle
extends MessageDialogWithToggle {
    private Map<String, Integer> buttonsMap;
    private boolean createToogleArea;

    public SiriusMessageDialogWithToggle(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, Map<String, Integer> buttons, int defaultIndex, String toggleMessage, boolean toggleState, boolean createToogleArea) {
        super(parentShell, dialogTitle, image, message, dialogImageType, buttons.keySet().toArray(new String[buttons.size()]), defaultIndex, toggleMessage, toggleState);
        this.buttonsMap = buttons;
        this.createToogleArea = createToogleArea;
    }

    protected Button createToggleButton(Composite parent) {
        if (this.createToogleArea) {
            return super.createToggleButton(parent);
        }
        return null;
    }

    protected void setToggleButton(Button button) {
        if (this.createToogleArea) {
            super.setToggleButton(button);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String[] buttonLabels = this.getButtonLabels();
        Button[] buttons = new Button[buttonLabels.length];
        int defaultButtonIndex = this.getDefaultButtonIndex();
        int suggestedId = 256;
        int i = 0;
        while (i < buttonLabels.length) {
            Button button;
            String label = buttonLabels[i];
            int id = this.mapButtonLabelToButtonID(label, suggestedId);
            if (id == suggestedId) {
                ++suggestedId;
            }
            buttons[i] = button = this.createButton(parent, id, label, defaultButtonIndex == i);
            ++i;
        }
        this.setButtons(buttons);
    }

    private int mapButtonLabelToButtonID(String buttonLabel, int defaultId) {
        if (IDialogConstants.OK_LABEL.equals(buttonLabel)) {
            return 0;
        }
        if (IDialogConstants.YES_LABEL.equals(buttonLabel)) {
            return 2;
        }
        if (IDialogConstants.NO_LABEL.equals(buttonLabel)) {
            return 3;
        }
        if (IDialogConstants.CANCEL_LABEL.equals(buttonLabel)) {
            return 1;
        }
        if (IDialogConstants.YES_TO_ALL_LABEL.equals(buttonLabel)) {
            return 4;
        }
        if (IDialogConstants.SKIP_LABEL.equals(buttonLabel)) {
            return 5;
        }
        if (IDialogConstants.STOP_LABEL.equals(buttonLabel)) {
            return 6;
        }
        if (IDialogConstants.ABORT_LABEL.equals(buttonLabel)) {
            return 7;
        }
        if (IDialogConstants.RETRY_LABEL.equals(buttonLabel)) {
            return 8;
        }
        if (IDialogConstants.IGNORE_LABEL.equals(buttonLabel)) {
            return 9;
        }
        if (IDialogConstants.PROCEED_LABEL.equals(buttonLabel)) {
            return 10;
        }
        if (IDialogConstants.OPEN_LABEL.equals(buttonLabel)) {
            return 11;
        }
        if (IDialogConstants.CLOSE_LABEL.equals(buttonLabel)) {
            return 12;
        }
        if (IDialogConstants.BACK_LABEL.equals(buttonLabel)) {
            return 14;
        }
        if (IDialogConstants.NEXT_LABEL.equals(buttonLabel)) {
            return 15;
        }
        if (IDialogConstants.FINISH_LABEL.equals(buttonLabel)) {
            return 16;
        }
        if (IDialogConstants.HELP_LABEL.equals(buttonLabel)) {
            return 17;
        }
        if (IDialogConstants.NO_TO_ALL_LABEL.equals(buttonLabel)) {
            return 21;
        }
        if (IDialogConstants.SHOW_DETAILS_LABEL.equals(buttonLabel)) {
            return 13;
        }
        if (IDialogConstants.HIDE_DETAILS_LABEL.equals(buttonLabel)) {
            return 13;
        }
        for (Map.Entry<String, Integer> providedButton : this.buttonsMap.entrySet()) {
            if (!providedButton.getKey().equals(buttonLabel)) continue;
            return providedButton.getValue();
        }
        return defaultId;
    }
}

