/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.CreateEMFModelWizardDataModel;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.NameAndLocationWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.SelectEMFMetamodelWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.SelectRootElementWizardPage;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.ISetSelectionTarget;

public class CreateEMFModelWizard
extends Wizard {
    private SelectEMFMetamodelWizardPage selectEMFMetamodelWizardPage;
    private SelectRootElementWizardPage selectRootElementWizardPage;
    private NameAndLocationWizardPage nameAndLocationWizardPage;
    private CreateEMFModelWizardDataModel dataModel = new CreateEMFModelWizardDataModel();
    private IFile result;

    public CreateEMFModelWizard(EPackage.Registry packageRegistry, IStructuredSelection selection) {
        this.selectEMFMetamodelWizardPage = new SelectEMFMetamodelWizardPage(packageRegistry, this.dataModel);
        this.selectRootElementWizardPage = new SelectRootElementWizardPage(this.dataModel);
        this.nameAndLocationWizardPage = new NameAndLocationWizardPage(selection, this.dataModel);
        this.setWindowTitle(Messages.CreateEMFModelWizard_windowTitle);
        this.dataModel.addPropertyChangeListener(this.selectRootElementWizardPage);
        this.dataModel.addPropertyChangeListener(this.nameAndLocationWizardPage);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.selectEMFMetamodelWizardPage);
        this.addPage((IWizardPage)this.selectRootElementWizardPage);
        this.addPage((IWizardPage)this.nameAndLocationWizardPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object nextPage = null;
        nextPage = page == this.selectEMFMetamodelWizardPage ? this.selectRootElementWizardPage : (page == this.selectRootElementWizardPage ? this.nameAndLocationWizardPage : (page == this.nameAndLocationWizardPage ? null : super.getNextPage(page)));
        return nextPage;
    }

    public boolean canFinish() {
        return this.dataModel.getSelectedPackage() != null && this.dataModel.getSelectedRootElement() != null && this.nameAndLocationWizardPage.validatePage();
    }

    public boolean performFinish() {
        final IFile modelFile = this.nameAndLocationWizardPage.getModelFile();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        Resource resource = resourceSet.createResource(fileURI);
                        EObject rootObject = CreateEMFModelWizard.this.instantiateRootElement();
                        if (rootObject != null) {
                            resource.getContents().add((Object)rootObject);
                        }
                        resource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getMessage()));
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            this.result = modelFile;
        }
        catch (InterruptedException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getMessage()));
        }
        catch (InvocationTargetException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getTargetException().getMessage()));
        }
        this.selectNewlyCreatedFile(modelFile);
        return true;
    }

    public IFile getResult() {
        return this.result;
    }

    private void selectNewlyCreatedFile(IFile modelFile) {
        IWorkbenchPart activePart;
        IWorkbenchPage page;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null && (activePart = page.getActivePart()) instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
    }

    private EObject instantiateRootElement() {
        EClass rootElement = this.dataModel.getSelectedRootElement();
        if (rootElement != null) {
            return EcoreUtil.create((EClass)rootElement);
        }
        return null;
    }
}

