/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.scxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingDatatype implements Enumerator
{
    EARLY(0, "early", "early"),
    LATE(1, "late", "late");

    public static final int EARLY_VALUE = 0;
    public static final int LATE_VALUE = 1;
    private static final BindingDatatype[] VALUES_ARRAY;
    public static final List<BindingDatatype> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingDatatype[]{EARLY, LATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingDatatype get(String literal) {
        BindingDatatype[] bindingDatatypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BindingDatatype result = bindingDatatypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BindingDatatype getByName(String name) {
        BindingDatatype[] bindingDatatypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BindingDatatype result = bindingDatatypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BindingDatatype get(int value) {
        switch (value) {
            case 0: {
                return EARLY;
            }
            case 1: {
                return LATE;
            }
        }
        return null;
    }

    private BindingDatatype(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

