/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;

@ServiceProvider(value="Services available for Comparables")
public class ComparableServices {
    private <T extends Comparable<? super T>> int safeCompare(T a, T b) {
        int result = a == null ? (b == null ? 0 : -b.compareTo(a)) : a.compareTo(b);
        return result;
    }

    @Documentation(value="Compares \"a\" to \"b\" and return \"true\" if \"a\" is less than \"b\".", params={@Param(name="a", value="The first comparable (can be null)"), @Param(name="b", value="The second comparable (can be null)")}, result="\"true\" \"a\" is less than \"b\", \"false\" otherwise.", examples={@Example(expression="'Hello' < 'Hello'", result="false"), @Example(expression="'Hello' < 'World'", result="true")})
    public <T extends Comparable<? super T>> Boolean lessThan(T a, T b) {
        return this.safeCompare(a, b) < 0;
    }

    @Documentation(value="Compares \"a\" to \"b\" and return \"true\" if \"a\" is less than or equal to \"b\".", params={@Param(name="a", value="The first comparable (can be null)"), @Param(name="b", value="The second comparable (can be null)")}, result="\"true\" \"a\" is less than or equal to \"b\", \"false\" otherwise.", examples={@Example(expression="'Hello' <='Hello'", result="true"), @Example(expression="'Hello' <='World'", result="true")})
    public <T extends Comparable<? super T>> Boolean lessThanEqual(T a, T b) {
        return this.safeCompare(a, b) <= 0;
    }

    @Documentation(value="Compares \"a\" to \"b\" and return \"true\" if \"a\" is greater than \"b\".", params={@Param(name="a", value="The first comparable (can be null)"), @Param(name="b", value="The second comparable (can be null)")}, result="\"true\" \"a\" is greater than \"b\", \"false\" otherwise.", examples={@Example(expression="'Hello' > 'Abc'", result="true"), @Example(expression="'Hello' > 'Hello'", result="false")})
    public <T extends Comparable<? super T>> Boolean greaterThan(T a, T b) {
        return this.safeCompare(a, b) > 0;
    }

    @Documentation(value="Compares \"a\" to \"b\" and return \"true\" if \"a\" is greater than or equal to \"b\".", params={@Param(name="a", value="The first comparable (can be null)"), @Param(name="b", value="The second comparable (can be null)")}, result="\"true\" \"a\" is greater than or equal to \"b\", \"false\" otherwise.", examples={@Example(expression="'Hello' >= 'Abc'", result="true"), @Example(expression="'Hello' >= 'Hello'", result="true")})
    public <T extends Comparable<? super T>> Boolean greaterThanEqual(T a, T b) {
        return this.safeCompare(a, b) >= 0;
    }
}

