/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.debug.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.elk.alg.disco.debug.DisCoDebugPlugin;
import org.eclipse.elk.alg.disco.debug.views.DisCoDebugView;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderingCanvas;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class DisCoImageExportAction
extends Action {
    private static final String ACTION_ID = "org.eclipse.elk.alg.disco.debug.imageExport";
    private static final String ICON_PATH = "icons/export.gif";
    private static final String LAST_FILE_NAME_PREF = "disCoImageExportAction.lastImageFile";
    private DisCoDebugView view;

    public DisCoImageExportAction(DisCoDebugView theview) {
        this.view = theview;
        this.setId(ACTION_ID);
        this.setText("&Export PNG");
        this.setToolTipText("Export the current graph as a PNG image file.");
        this.setImageDescriptor(DisCoDebugPlugin.imageDescriptorFromPlugin((String)"org.eclipse.elk.alg.disco.debug", (String)ICON_PATH));
    }

    public void run() {
        String fileName;
        final DisCoGraphRenderingCanvas canvas = this.view.getCanvas();
        if (canvas != null && (fileName = DisCoImageExportAction.getFileName(canvas.getDisplay())) != null) {
            Job saveJob = new Job("Export PNG Image"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Export PNG Image", 2);
                        ElkNode graph = canvas.getLayoutGraph();
                        double scale = canvas.getRenderer().getScale();
                        Rectangle area = new Rectangle(0, 0, (int)((graph.getWidth() + 1.0) * scale), (int)((graph.getHeight() + 1.0) * scale));
                        Image image = new Image((Device)canvas.getDisplay(), area.width, area.height);
                        canvas.getRenderer().markDirty(area);
                        GC dummyGC = new GC((Drawable)image);
                        canvas.getRenderer().render(graph, dummyGC, area);
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            Status status = new Status(1, "org.eclipse.elk.alg.disco.debug", 0, "Aborted", null);
                            return status;
                        }
                        ImageLoader imageLoader = new ImageLoader();
                        ImageData[] imageData = new ImageData[]{image.getImageData()};
                        imageLoader.compression = 3;
                        imageLoader.data = imageData;
                        imageLoader.save(fileName, 5);
                        monitor.worked(1);
                        Status status = new Status(1, "org.eclipse.elk.alg.disco.debug", 0, "OK", null);
                        return status;
                    }
                    catch (SWTException exception) {
                        Status status = new Status(4, "org.eclipse.elk.alg.disco.debug", exception.code, "Could not save the selected PNG file.", (Throwable)exception);
                        return status;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            IProgressMonitor monitor = Job.getJobManager().createProgressGroup();
            saveJob.setProgressGroup(monitor, 2);
            saveJob.setPriority(20);
            saveJob.setUser(true);
            saveJob.schedule();
        }
    }

    private static String getFileName(Display display) {
        IPreferenceStore preferenceStore = DisCoDebugPlugin.getDefault().getPreferenceStore();
        FileDialog fileDialog = new FileDialog(display.getActiveShell(), 8192);
        String[] extensions = new String[]{"*.png"};
        fileDialog.setFilterExtensions(extensions);
        String[] names = new String[]{"Portable Network Graphics files"};
        fileDialog.setFilterNames(names);
        fileDialog.setOverwrite(true);
        fileDialog.setText("Select Output File");
        fileDialog.setFileName(preferenceStore.getString(LAST_FILE_NAME_PREF));
        String fileName = DisCoImageExportAction.checkFileName(fileDialog.open());
        if (fileName != null) {
            preferenceStore.setValue(LAST_FILE_NAME_PREF, fileName);
        }
        return fileName;
    }

    private static String checkFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String nameCopy = new String(fileName).toLowerCase();
        if (nameCopy.endsWith(".png")) {
            return fileName;
        }
        if (nameCopy.endsWith(".pn")) {
            return String.valueOf(fileName) + "g";
        }
        if (nameCopy.endsWith(".p")) {
            return String.valueOf(fileName) + "ng";
        }
        if (nameCopy.endsWith(".")) {
            return String.valueOf(fileName) + "png";
        }
        return String.valueOf(fileName) + ".png";
    }
}

