/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.Margins;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;

public class PrintJob {
    private final String name;
    private final Print document;
    private Margins margins = new Margins();
    private int orientation = -1;

    public PrintJob(String name, Print document) {
        Util.notNull(name, document);
        this.name = name;
        this.document = document;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
        result = 31 * result + (this.margins == null ? 0 : this.margins.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.orientation;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintJob other = (PrintJob)obj;
        if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
            return false;
        }
        if (this.margins == null ? other.margins != null : !this.margins.equals(other.margins)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.orientation == other.orientation;
    }

    public String getName() {
        return this.name;
    }

    public Print getDocument() {
        return this.document;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public PrintJob setOrientation(int orientation) {
        this.orientation = this.checkOrientation(orientation);
        return this;
    }

    private int checkOrientation(int orientation) {
        switch (orientation) {
            case -1: 
            case 256: 
            case 512: {
                return orientation;
            }
        }
        return -1;
    }

    public Margins getMargins() {
        return this.margins;
    }

    public PrintJob setMargins(Margins margins) {
        Util.notNull(margins);
        this.margins = margins;
        return this;
    }

    public PrintJob setMargins(int margins) {
        this.margins = new Margins(margins);
        return this;
    }
}

