/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.draw2d.figure;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.ext.draw2d.figure.PolygoneAndPolylineDecoraction;

public class PolygoneAndPolylineWithDotDecoration
extends PolygoneAndPolylineDecoraction {
    private static final int DOT_DIAMETER = 6;
    private Ellipse dot = new Ellipse();

    public PolygoneAndPolylineWithDotDecoration() {
        this.dot.setSize(6, 6);
        this.dot.setFill(true);
        this.add((IFigure)this.dot);
        this.dot.setLocation(new Point());
        PointList arrow = TRIANGLE_TIP.getCopy();
        arrow.translate(1, 0);
        this.setPolylineTemplate(arrow);
    }

    protected void paintChildren(Graphics graphics) {
        this.dot.setBackgroundColor(graphics.getForegroundColor());
        super.paintChildren(graphics);
    }

    @Override
    public Rectangle getBounds() {
        if (this.dot != null) {
            Rectangle b = super.getBounds();
            b.union(this.dot.getBounds());
            return b;
        }
        return super.getBounds();
    }

    @Override
    public void setLocation(Point p) {
        super.setLocation(p);
        Point ellipseLocation = new Point(p);
        this.dot.setLocation(ellipseLocation.translate(new Point(-3, -3)));
    }

    @Override
    public void setRotation(double angle) {
        int translatationX = (int)(6.0 * Math.cos(angle));
        int translationY = (int)(6.0 * Math.sin(angle));
        this.dot.setLocation(new Point(this.dot.getLocation().x - translatationX / 2, this.dot.getLocation().y - translationY / 2));
        super.setRotation(angle);
    }
}

