/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.description.tool.CreateEdgeView;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.description.tool.DiagramCreationDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.description.tool.util.ToolSwitch;
import org.eclipse.sirius.diagram.description.util.DescriptionSwitch;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.DragSource;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.Let;

public class DiagramExistingExpressionVariablesConstraint
extends AbstractConstraint {
    private static final Set<String> VPE_MAPPING_PRECONDITION_VARIABLES = new HashSet<String>(2);
    private static final Set<String> VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES;
    private static final Set<String> EDGE_MAPPING_TARGET_FINDER_VARIABLES;
    private static final Set<String> EDGE_MAPPING_SOURCE_FINDER_VARIABLES;
    private static final Set<String> EDGE_MAPPING_TARGET_VARIABLES;
    private static final Set<String> EDGE_MAPPING_PATH_VARIABLES;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DEF;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_EDGE;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DELETE;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL;
    private static final Set<String> COND_STYLE_PREDICATE_VARIABLES;

    static {
        VPE_MAPPING_PRECONDITION_VARIABLES.add("container");
        VPE_MAPPING_PRECONDITION_VARIABLES.add("containerView");
        VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES = new HashSet<String>(2);
        VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES.add("viewpoint");
        VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES.add("diagram");
        EDGE_MAPPING_TARGET_FINDER_VARIABLES = new HashSet<String>(1);
        EDGE_MAPPING_TARGET_FINDER_VARIABLES.add("viewPoint");
        EDGE_MAPPING_SOURCE_FINDER_VARIABLES = new HashSet<String>(1);
        EDGE_MAPPING_SOURCE_FINDER_VARIABLES.add("viewPoint");
        EDGE_MAPPING_TARGET_VARIABLES = new HashSet<String>(3);
        EDGE_MAPPING_TARGET_VARIABLES.add("viewpoint");
        EDGE_MAPPING_TARGET_VARIABLES.add("diagram");
        EDGE_MAPPING_TARGET_VARIABLES.add("targetSemanticNode");
        EDGE_MAPPING_PATH_VARIABLES = new HashSet<String>(5);
        EDGE_MAPPING_PATH_VARIABLES.add("viewpoint");
        EDGE_MAPPING_PATH_VARIABLES.add("diagram");
        EDGE_MAPPING_PATH_VARIABLES.add("element");
        EDGE_MAPPING_PATH_VARIABLES.add("source");
        EDGE_MAPPING_PATH_VARIABLES.add("target");
        COND_STYLE_PREDICATE_VARIABLES = new HashSet<String>(2);
        COND_STYLE_PREDICATE_VARIABLES.add("container");
        COND_STYLE_PREDICATE_VARIABLES.add("view");
        TOOL_DESC_PRECONDITION_VARIABLES_DEF = new HashSet<String>(1);
        TOOL_DESC_PRECONDITION_VARIABLES_DEF.add("container");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE = new HashSet<String>(5);
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preSource");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preTarget");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preSourceView");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preTargetView");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("container");
        TOOL_DESC_PRECONDITION_VARIABLES_DELETE = new HashSet<String>(2);
        TOOL_DESC_PRECONDITION_VARIABLES_DELETE.add("containerView");
        TOOL_DESC_PRECONDITION_VARIABLES_DELETE.add("element");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG = new HashSet<String>(4);
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("oldContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("newContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("newViewContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("element");
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL = new HashSet<String>(3);
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL.add("newContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL.add("newViewContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL.add("element");
    }

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (this.shouldValidate(eObj) && eventType == EMFEventType.NULL) {
            IStatus status = ctx.createSuccessStatus();
            DescriptionSwitchValidator descriptionSwitchValidator = new DescriptionSwitchValidator(ctx, status);
            IStatus result = descriptionSwitchValidator.doSwitch(eObj);
            result = this.validateTool(eObj, ctx, result);
            return result;
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateTool(EObject eObj, IValidationContext ctx, IStatus statusInput) {
        ToolSwitchValidator toolSwitchValidator = new ToolSwitchValidator(ctx, statusInput);
        IStatus status = toolSwitchValidator.doSwitch(eObj);
        return status;
    }

    private IStatus checkDiagramDescriptionPrecondition(IValidationContext ctx, DiagramDescription vpDescription) {
        return this.checkVariables(ctx, vpDescription.getPreconditionExpression(), Collections.emptySet(), (EObject)vpDescription, DescriptionPackage.eINSTANCE.getDiagramDescription_PreconditionExpression().getName());
    }

    private IStatus checkDiagramElementMappingPrecondition(IValidationContext ctx, DiagramElementMapping vpeMapping) {
        return this.checkVariables(ctx, vpeMapping.getPreconditionExpression(), VPE_MAPPING_PRECONDITION_VARIABLES, (EObject)vpeMapping, DescriptionPackage.eINSTANCE.getDiagramElementMapping_PreconditionExpression().getName());
    }

    private IStatus checkDiagramElementMappingSemanticCandidates(IValidationContext ctx, DiagramElementMapping vpeMapping) {
        return this.checkVariables(ctx, vpeMapping.getSemanticCandidatesExpression(), VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES, (EObject)vpeMapping, DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticCandidatesExpression().getName());
    }

    private IStatus checkDiagramElementMappingSemanticElements(IValidationContext ctx, DiagramElementMapping vpeMapping) {
        return this.checkVariables(ctx, vpeMapping.getSemanticElements(), Collections.emptySet(), (EObject)vpeMapping, DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticElements().getName());
    }

    private IStatus checkNodeMappingLabel(IValidationContext ctx, NodeMapping nodeMapping) {
        if (MappingWithInterpreterHelper.getDefaultStyleDescription((DiagramElementMapping)nodeMapping) != null) {
            return this.checkVariables(ctx, ((NodeStyleDescription)MappingWithInterpreterHelper.getDefaultStyleDescription((DiagramElementMapping)nodeMapping)).getLabelExpression(), Collections.emptySet(), (EObject)nodeMapping, StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression().getName());
        }
        return ctx.createSuccessStatus();
    }

    private IStatus checkNodeMappingSizeComputation(IValidationContext ctx, NodeMapping nodeMapping) {
        if (MappingWithInterpreterHelper.getDefaultStyleDescription((DiagramElementMapping)nodeMapping) != null) {
            return this.checkVariables(ctx, ((NodeStyleDescription)MappingWithInterpreterHelper.getDefaultStyleDescription((DiagramElementMapping)nodeMapping)).getSizeComputationExpression(), Collections.emptySet(), (EObject)nodeMapping, org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getNodeStyleDescription_SizeComputationExpression().getName());
        }
        return ctx.createSuccessStatus();
    }

    private IStatus checkContainerMappingLabel(IValidationContext ctx, ContainerMapping containerMapping) {
        if (MappingWithInterpreterHelper.getDefaultStyleDescription((DiagramElementMapping)containerMapping) != null) {
            return this.checkVariables(ctx, ((ContainerStyleDescription)MappingWithInterpreterHelper.getDefaultStyleDescription((DiagramElementMapping)containerMapping)).getLabelExpression(), Collections.emptySet(), (EObject)containerMapping, StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression().getName());
        }
        return ctx.createSuccessStatus();
    }

    private IStatus checkEdgeMappingTargetFinder(IValidationContext ctx, EdgeMapping edgeMapping) {
        return this.checkVariables(ctx, edgeMapping.getTargetFinderExpression(), EDGE_MAPPING_TARGET_FINDER_VARIABLES, (EObject)edgeMapping, DescriptionPackage.eINSTANCE.getEdgeMapping_TargetFinderExpression().getName());
    }

    private IStatus checkEdgeMappingSourceFinder(IValidationContext ctx, EdgeMapping edgeMapping) {
        return this.checkVariables(ctx, edgeMapping.getSourceFinderExpression(), EDGE_MAPPING_SOURCE_FINDER_VARIABLES, (EObject)edgeMapping, DescriptionPackage.eINSTANCE.getEdgeMapping_SourceFinderExpression().getName());
    }

    private IStatus checkEdgeMappingSizeComputation(IValidationContext ctx, EdgeMapping edgeMapping) {
        if (edgeMapping.getStyle() != null) {
            return this.checkVariables(ctx, edgeMapping.getStyle().getSizeComputationExpression(), Collections.emptySet(), (EObject)edgeMapping, org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getEdgeStyleDescription_SizeComputationExpression().getName());
        }
        return ctx.createSuccessStatus();
    }

    private IStatus checkEdgeMappingLabelComputation(IValidationContext ctx, EdgeMapping edgeMapping) {
        if (edgeMapping.getStyle() != null && edgeMapping.getStyle().getCenterLabelStyleDescription() != null) {
            return this.checkVariables(ctx, edgeMapping.getStyle().getCenterLabelStyleDescription().getLabelExpression(), Collections.emptySet(), (EObject)edgeMapping, StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression().getName());
        }
        return ctx.createSuccessStatus();
    }

    private IStatus checkEdgeMappingTarget(IValidationContext ctx, EdgeMapping edgeMapping) {
        return this.checkVariables(ctx, edgeMapping.getTargetExpression(), EDGE_MAPPING_TARGET_VARIABLES, (EObject)edgeMapping, DescriptionPackage.eINSTANCE.getEdgeMapping_TargetExpression().getName());
    }

    private IStatus checkEdgeMappingPath(IValidationContext ctx, EdgeMapping edgeMapping) {
        return this.checkVariables(ctx, edgeMapping.getPathExpression(), EDGE_MAPPING_PATH_VARIABLES, (EObject)edgeMapping, DescriptionPackage.eINSTANCE.getEdgeMapping_PathExpression().getName());
    }

    private IStatus checkConditionalStylePredicate(IValidationContext ctx, ConditionalStyleDescription conditionalStyle) {
        return this.checkVariables(ctx, conditionalStyle.getPredicateExpression(), COND_STYLE_PREDICATE_VARIABLES, (EObject)conditionalStyle, org.eclipse.sirius.viewpoint.description.DescriptionPackage.eINSTANCE.getConditionalStyleDescription_PredicateExpression().getName());
    }

    private IStatus checkAbstractToolDescriptionPrecondition(IValidationContext ctx, AbstractToolDescription abstractToolDescription) {
        Set<String> variables = TOOL_DESC_PRECONDITION_VARIABLES_DEF;
        if (abstractToolDescription instanceof EdgeCreationDescription) {
            variables = TOOL_DESC_PRECONDITION_VARIABLES_EDGE;
        } else if (abstractToolDescription instanceof DeleteElementDescription) {
            variables = TOOL_DESC_PRECONDITION_VARIABLES_DELETE;
        } else if (abstractToolDescription instanceof ContainerDropDescription) {
            ContainerDropDescription cdd = (ContainerDropDescription)abstractToolDescription;
            variables = cdd.getDragSource() == DragSource.PROJECT_EXPLORER_LITERAL ? TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL : TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG;
        } else if (abstractToolDescription instanceof DiagramCreationDescription) {
            variables = Collections.emptySet();
        }
        return this.checkVariables(ctx, abstractToolDescription.getPrecondition(), variables, (EObject)abstractToolDescription, org.eclipse.sirius.viewpoint.description.tool.ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition().getName());
    }

    private IStatus checkCreateViewContainerView(IValidationContext ctx, CreateView createViewOp) {
        return this.checkVariables(ctx, createViewOp.getContainerViewExpression(), this.getDeclaredVariables((EObject)createViewOp), (EObject)createViewOp, ToolPackage.eINSTANCE.getCreateView_ContainerViewExpression().getName());
    }

    private IStatus checkCreateEdgeViewSource(IValidationContext ctx, CreateEdgeView createEdgeViewOp) {
        return this.checkVariables(ctx, createEdgeViewOp.getSourceExpression(), this.getDeclaredVariables((EObject)createEdgeViewOp), (EObject)createEdgeViewOp, ToolPackage.eINSTANCE.getCreateEdgeView_SourceExpression().getName());
    }

    private IStatus checkCreateEdgeViewTarget(IValidationContext ctx, CreateEdgeView createEdgeViewOp) {
        return this.checkVariables(ctx, createEdgeViewOp.getTargetExpression(), this.getDeclaredVariables((EObject)createEdgeViewOp), (EObject)createEdgeViewOp, ToolPackage.eINSTANCE.getCreateEdgeView_TargetExpression().getName());
    }

    protected Set<String> getDeclaredVariables(EObject context) {
        HashSet<String> result = new HashSet<String>();
        AbstractToolDescription tool = null;
        EObject current = context;
        while (tool == null && current.eContainer() != null) {
            if (current instanceof AbstractToolDescription) {
                tool = (AbstractToolDescription)current;
            }
            current = current.eContainer();
        }
        if (tool != null) {
            TreeIterator iterAllContents = tool.eAllContents();
            while (iterAllContents.hasNext()) {
                String name;
                EObject next = (EObject)iterAllContents.next();
                if (next instanceof AbstractVariable) {
                    result.add(((AbstractVariable)next).getName());
                    continue;
                }
                if (next instanceof For) {
                    result.add(((For)next).getIteratorName());
                    continue;
                }
                if (next instanceof CreateInstance) {
                    name = ((CreateInstance)next).getVariableName();
                    if (StringUtil.isEmpty((String)name)) continue;
                    result.add(name);
                    continue;
                }
                if (!(next instanceof Let) || StringUtil.isEmpty((String)(name = ((Let)next).getVariableName()))) continue;
                result.add(name);
            }
            if (tool instanceof DirectEditLabel) {
                DirectEditLabel directEditLabel = (DirectEditLabel)tool;
                EditMaskVariables maskVariables = directEditLabel.getMask();
                MessageFormat parser = new MessageFormat(maskVariables.getMask());
                int i = 0;
                while (i < parser.getFormats().length) {
                    result.add(Integer.valueOf(i).toString());
                    result.add("arg" + Integer.valueOf(i).toString());
                    ++i;
                }
            }
        }
        return result;
    }

    public class DescriptionSwitchValidator
    extends DescriptionSwitch<IStatus> {
        private IStatus currentStatus;
        private final IValidationContext ctx;

        public DescriptionSwitchValidator(IValidationContext ctx, IStatus currentStatus) {
            this.currentStatus = currentStatus;
            this.ctx = ctx;
            if (this.currentStatus == null) {
                this.currentStatus = ctx.createSuccessStatus();
            }
        }

        public IStatus caseDiagramDescription(DiagramDescription object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseDiagramDescription(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? DiagramExistingExpressionVariablesConstraint.this.checkDiagramDescriptionPrecondition(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        public IStatus caseDiagramElementMapping(DiagramElementMapping object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseDiagramElementMapping(object);
                if (superStatus == null || superStatus.isOK()) {
                    this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkDiagramElementMappingPrecondition(this.ctx, object);
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkDiagramElementMappingSemanticCandidates(this.ctx, object);
                    }
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkDiagramElementMappingSemanticElements(this.ctx, object);
                    }
                } else {
                    this.currentStatus = superStatus;
                }
            }
            return this.currentStatus;
        }

        public IStatus caseNodeMapping(NodeMapping object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseNodeMapping(object);
                if (superStatus == null || superStatus.isOK()) {
                    this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkNodeMappingLabel(this.ctx, object);
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkNodeMappingSizeComputation(this.ctx, object);
                    }
                } else {
                    this.currentStatus = superStatus;
                }
            }
            return this.currentStatus;
        }

        public IStatus caseContainerMapping(ContainerMapping object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseContainerMapping(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? DiagramExistingExpressionVariablesConstraint.this.checkContainerMappingLabel(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        public IStatus caseEdgeMapping(EdgeMapping object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseEdgeMapping(object);
                if (superStatus == null || superStatus.isOK()) {
                    this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkEdgeMappingTargetFinder(this.ctx, object);
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkEdgeMappingSourceFinder(this.ctx, object);
                    }
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkEdgeMappingSizeComputation(this.ctx, object);
                    }
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkEdgeMappingLabelComputation(this.ctx, object);
                    }
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkEdgeMappingTarget(this.ctx, object);
                    }
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkEdgeMappingPath(this.ctx, object);
                    }
                } else {
                    this.currentStatus = superStatus;
                }
            }
            return this.currentStatus;
        }

        public IStatus caseConditionalStyleDescription(ConditionalStyleDescription object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseConditionalStyleDescription(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? DiagramExistingExpressionVariablesConstraint.this.checkConditionalStylePredicate(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        public IStatus doSwitch(EObject theEObject) {
            if (this.currentStatus.isOK()) {
                this.currentStatus = (IStatus)super.doSwitch(theEObject);
            }
            return this.currentStatus;
        }
    }

    public class ToolSwitchValidator
    extends ToolSwitch<IStatus> {
        private IStatus currentStatus;
        private final IValidationContext ctx;

        public ToolSwitchValidator(IValidationContext ctx, IStatus currentStatus) {
            this.currentStatus = currentStatus;
            this.ctx = ctx;
            if (this.currentStatus == null) {
                this.currentStatus = ctx.createSuccessStatus();
            }
        }

        public IStatus caseAbstractToolDescription(AbstractToolDescription object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseAbstractToolDescription(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? DiagramExistingExpressionVariablesConstraint.this.checkAbstractToolDescriptionPrecondition(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        public IStatus caseCreateView(CreateView object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseCreateView(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? DiagramExistingExpressionVariablesConstraint.this.checkCreateViewContainerView(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        public IStatus caseCreateEdgeView(CreateEdgeView object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseCreateEdgeView(object);
                if (superStatus == null || superStatus.isOK()) {
                    this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkCreateEdgeViewSource(this.ctx, object);
                    if (this.currentStatus.isOK()) {
                        this.currentStatus = DiagramExistingExpressionVariablesConstraint.this.checkCreateEdgeViewTarget(this.ctx, object);
                    }
                } else {
                    this.currentStatus = superStatus;
                }
            }
            return this.currentStatus;
        }

        public IStatus doSwitch(EObject theEObject) {
            if (this.currentStatus == null || this.currentStatus.isOK()) {
                this.currentStatus = (IStatus)super.doSwitch(theEObject);
            }
            return this.currentStatus;
        }
    }
}

