/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.colors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorCategoryManager;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.internal.colors.ColorsAnnotationHelper;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractColorCategoryManager
implements ColorCategoryManager {
    public static final String FILL_CUSTOM_COLORS_ANNOTATION_SOURCE_NAME = "FillCustomColors";
    public static final String FILL_SUGGESTED_COLORS_ANNOTATION_SOURCE_NAME = "FillSuggestedColors";
    public static final String FONT_CUSTOM_COLORS_ANNOTATION_SOURCE_NAME = "FontCustomColors";
    public static final String FONT_SUGGESTED_COLORS_ANNOTATION_SOURCE_NAME = "FontSuggestedColors";
    public static final String LINE_CUSTOM_COLORS_ANNOTATION_SOURCE_NAME = "LineCustomColors";
    public static final String LINE_SUGGESTED_COLORS_ANNOTATION_SOURCE_NAME = "LineSuggestedColors";
    private static final List<SystemColors> BASIC_COLORS = Arrays.asList(SystemColors.BLACK_LITERAL, SystemColors.DARK_GRAY_LITERAL, SystemColors.LIGHT_GRAY_LITERAL, SystemColors.WHITE_LITERAL, SystemColors.RED_LITERAL, SystemColors.ORANGE_LITERAL, SystemColors.YELLOW_LITERAL, SystemColors.GREEN_LITERAL, SystemColors.BLUE_LITERAL, SystemColors.PURPLE_LITERAL);
    private static final int NB_MAX_LAST_USED_COLORS = 10;
    private static final int NB_MAX_SUGGESTED_COLORS = 10;
    private static final String RGB_VALUES_SEPARATOR = ",";
    protected ColorsAnnotationHelper colorsAnnotationHelper;
    private List<IGraphicalEditPart> editParts;

    public AbstractColorCategoryManager(Session session, List<IGraphicalEditPart> editParts) {
        this.editParts = editParts;
        this.colorsAnnotationHelper = new ColorsAnnotationHelper(session);
    }

    @Override
    public List<RGB> getBasicColors() {
        LinkedList<RGB> basicColors = new LinkedList<RGB>();
        Map systemColors = VisualBindingManager.getDefault().getSystemPalette();
        for (SystemColors color : BASIC_COLORS) {
            basicColors.add((RGB)systemColors.get(color.getName()));
        }
        return basicColors;
    }

    protected List<RGB> getLastUsedColors(String lastUsedColorsPreference) {
        String lastUsedColorsString = DiagramUIPlugin.getPlugin().getPreferenceStore().getString(lastUsedColorsPreference);
        LinkedList<RGB> lastUsedColors = new LinkedList<RGB>();
        if (!lastUsedColorsString.isEmpty()) {
            String[] stringArray = lastUsedColorsString.split("},");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                RGB color = ColorManager.getDefault().stringToRGB(s + "}");
                lastUsedColors.add(color);
                ++n2;
            }
        }
        return lastUsedColors;
    }

    protected void addLastUsedColor(RGB lastUsedColor, String lastUsedColorsPreference) {
        List<RGB> lastUsedColors = this.getLastUsedColors(lastUsedColorsPreference);
        if (lastUsedColor != null) {
            if (!lastUsedColors.contains(lastUsedColor)) {
                lastUsedColors.add(0, lastUsedColor);
            } else {
                lastUsedColors.remove(lastUsedColor);
                lastUsedColors.add(0, lastUsedColor);
            }
            Object lastUsedColorsString = new String();
            int i = 0;
            while (i < lastUsedColors.size() && i < 10) {
                RGB rgb = lastUsedColors.get(i);
                lastUsedColorsString = (String)lastUsedColorsString + ColorManager.getDefault().rgbToString(rgb) + RGB_VALUES_SEPARATOR;
                ++i;
            }
            IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
            preferenceStore.putValue(lastUsedColorsPreference, (String)lastUsedColorsString);
        }
    }

    protected List<RGB> getColors(String colorsAnnotationSourceName) {
        return this.colorsAnnotationHelper.getColorsDetails(colorsAnnotationSourceName);
    }

    protected void setColors(String colorsAnnotationSourceName, List<RGB> colorsList) {
        if (colorsList != null) {
            this.colorsAnnotationHelper.setColorsDetails(colorsAnnotationSourceName, colorsList);
        }
    }

    protected void setSuggestedColors(String colorsAnnotationSourceName, List<RGB> colorsList) {
        if (colorsList != null) {
            ArrayList<RGB> newColorsList = colorsList.size() > 10 ? new ArrayList<RGB>(colorsList.subList(0, 10)) : new ArrayList<RGB>(colorsList);
            this.setColors(colorsAnnotationSourceName, newColorsList);
        }
    }

    protected List<RGB> getSelectedColorsByPropertyId(String propertyId) {
        List<RGB> selectedColorsByPropertyId = Collections.EMPTY_LIST;
        if (this.editParts != null) {
            EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)propertyId);
            selectedColorsByPropertyId = this.editParts.stream().map(ep -> ep.getStructuralFeatureValue(feature)).filter(Integer.class::isInstance).map(Integer.class::cast).map(colorInteger -> FigureUtilities.integerToRGB((Integer)colorInteger)).distinct().toList();
        }
        return selectedColorsByPropertyId;
    }
}

