/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect.description;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.metamodel.table.description.BackgroundConditionalStyle;
import org.eclipse.sirius.table.metamodel.table.description.BackgroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateCrossColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateLineTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteLineTool;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundConditionalStyle;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableCreationDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableNavigationDescription;
import org.eclipse.sirius.table.metamodel.table.description.util.DescriptionSwitch;

public class TableInterpretedTargetSwitch
extends DescriptionSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected int featureID;
    protected IInterpretedExpressionTargetSwitch globalSwitch;
    private int lastFeatureID;

    public TableInterpretedTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch globalSwitch) {
        this.lastFeatureID = this.featureID = feature != null ? feature.getFeatureID() : -1;
        this.globalSwitch = globalSwitch;
    }

    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        LinkedHashSet defaultResult = new LinkedHashSet();
        return Options.newSome(defaultResult);
    }

    private EObject getFirstRelevantContainer(EObject element) {
        return this.globalSwitch.getFirstRelevantContainer(element);
    }

    private EObject getLineMapping(FeatureColumnMapping featureColumnMapping) {
        Iterator siblings = Iterables.filter((Iterable)featureColumnMapping.eContainer().eContents(), LineMapping.class).iterator();
        if (siblings.hasNext()) {
            return (EObject)siblings.next();
        }
        return this.getFirstRelevantContainer((EObject)featureColumnMapping);
    }

    public Option<Collection<String>> caseTableDescription(TableDescription object) {
        Option result = null;
        LinkedHashSet<String> target = new LinkedHashSet<String>();
        switch (this.featureID) {
            case -1: 
            case 4: 
            case 8: {
                target.add(object.getDomainClass());
                result = Options.newSome(target);
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseLineMapping(LineMapping object) {
        Option result = null;
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        switch (this.featureID) {
            case 16: {
                result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
                break;
            }
            case -1: 
            case 4: 
            case 17: {
                targets.add(object.getDomainClass());
                result = Options.newSome(targets);
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseElementColumnMapping(ElementColumnMapping object) {
        Option result = null;
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        switch (this.featureID) {
            case 12: {
                result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
                break;
            }
            case -1: 
            case 4: 
            case 5: {
                targets.add(object.getDomainClass());
                result = Options.newSome(targets);
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseFeatureColumnMapping(FeatureColumnMapping object) {
        Option result = null;
        switch (this.featureID) {
            case -1: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 16: {
                result = this.globalSwitch.doSwitch(this.getLineMapping(object), false);
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseCellUpdater(CellUpdater object) {
        Option result = null;
        switch (this.featureID) {
            case -1: 
            case 1: {
                result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseIntersectionMapping(IntersectionMapping object) {
        Option result = null;
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        if (object.isUseDomainClass()) {
            switch (this.featureID) {
                case 18: {
                    result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
                    break;
                }
                case -1: 
                case 4: 
                case 6: 
                case 14: 
                case 16: 
                case 17: 
                case 20: {
                    targets.add(object.getDomainClass());
                    result = Options.newSome(targets);
                    break;
                }
            }
        } else {
            switch (this.featureID) {
                case -1: 
                case 4: 
                case 6: 
                case 14: 
                case 16: 
                case 20: {
                    for (LineMapping lineMapping : object.getLineMapping()) {
                        Option lineMappingTargets = this.globalSwitch.doSwitch((EObject)lineMapping, false);
                        if (!lineMappingTargets.some()) continue;
                        targets.addAll((Collection)lineMappingTargets.get());
                    }
                    result = Options.newSome(targets);
                    break;
                }
                case 17: 
                case 18: {
                    result = Options.newNone();
                    break;
                }
            }
        }
        return result;
    }

    public Option<Collection<String>> caseCreateColumnTool(CreateColumnTool object) {
        return this.globalSwitch.doSwitch((EObject)object.getMapping(), false);
    }

    public Option<Collection<String>> caseCreateCellTool(CreateCellTool object) {
        return this.globalSwitch.doSwitch((EObject)object.getMapping(), false);
    }

    public Option<Collection<String>> caseCreateCrossColumnTool(CreateCrossColumnTool object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    public Option<Collection<String>> caseCreateLineTool(CreateLineTool object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    public Option<Collection<String>> caseDeleteColumnTool(DeleteColumnTool object) {
        return this.globalSwitch.doSwitch((EObject)object.getMapping(), false);
    }

    public Option<Collection<String>> caseDeleteLineTool(DeleteLineTool object) {
        return this.globalSwitch.doSwitch((EObject)object.getMapping(), false);
    }

    public Option<Collection<String>> caseForegroundConditionalStyle(ForegroundConditionalStyle object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    public Option<Collection<String>> caseForegroundStyleDescription(ForegroundStyleDescription object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    public Option<Collection<String>> caseBackgroundConditionalStyle(BackgroundConditionalStyle object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    public Option<Collection<String>> caseBackgroundStyleDescription(BackgroundStyleDescription object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    public Option<Collection<String>> caseTableCreationDescription(TableCreationDescription object) {
        return this.globalSwitch.doSwitch((EObject)object.getTableDescription(), false);
    }

    public Option<Collection<String>> caseTableNavigationDescription(TableNavigationDescription object) {
        return this.globalSwitch.doSwitch((EObject)object.getTableDescription(), false);
    }

    public void setConsiderFeature(boolean considerFeature) {
        if (considerFeature) {
            this.featureID = this.lastFeatureID;
        } else {
            this.lastFeatureID = this.featureID;
            this.featureID = -1;
        }
    }
}

