/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.wizards.page;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointsSelectionGraphicalHandler;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ViewpointsSelectionWizardPage
extends WizardPage {
    private List<Viewpoint> viewpoints;
    private ArrayList<String> viewpointsNamesToActivateByDefault;
    private ViewpointsSelectionGraphicalHandler viewpointsSelectionGraphicalHandler;
    private Session session;

    public ViewpointsSelectionWizardPage(Session theSession) {
        super(Messages.ViewpointsSelectionWizardPage_title);
        this.setTitle(Messages.ViewpointsSelectionWizardPage_title);
        this.setMessage(Messages.ViewpointsSelectionWizardPage_message);
        this.viewpoints = new ArrayList<Viewpoint>();
        this.viewpointsNamesToActivateByDefault = new ArrayList();
        this.viewpointsSelectionGraphicalHandler = new ViewpointsSelectionGraphicalHandler();
        this.session = theSession;
    }

    public ViewpointsSelectionWizardPage(Session theSession, List<String> viewpointsNamesToActivateByDefault) {
        super(Messages.ViewpointsSelectionWizardPage_title);
        this.setTitle(Messages.ViewpointsSelectionWizardPage_title);
        this.setMessage(Messages.ViewpointsSelectionWizardPage_message);
        this.viewpoints = new ArrayList<Viewpoint>();
        this.viewpointsNamesToActivateByDefault = new ArrayList<String>(viewpointsNamesToActivateByDefault);
        this.viewpointsSelectionGraphicalHandler = new ViewpointsSelectionGraphicalHandler();
        this.session = theSession;
    }

    public boolean isPageComplete() {
        String errorMessage = null;
        boolean complete = false;
        if (!this.viewpoints.isEmpty()) {
            Map<String, Collection<String>> missingDependencies = ViewpointSelection.getMissingDependencies(new HashSet<Viewpoint>(this.viewpoints));
            if (missingDependencies.isEmpty()) {
                complete = true;
            } else {
                errorMessage = ViewpointSelection.getMissingDependenciesErrorMessage(missingDependencies);
            }
        }
        this.setErrorMessage(errorMessage);
        return complete;
    }

    public List<Viewpoint> getViewpoints() {
        return this.viewpoints;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.viewpointsSelectionGraphicalHandler.createControl(parent, true);
        CheckboxTableViewer tableViewer = this.viewpointsSelectionGraphicalHandler.getViewer();
        tableViewer.setInput(this.getAvailableViewpoints());
        if (!this.viewpointsNamesToActivateByDefault.isEmpty()) {
            int i = 0;
            while (i < tableViewer.getTable().getItemCount()) {
                Object object = tableViewer.getElementAt(i);
                if (object instanceof Viewpoint && this.viewpointsNamesToActivateByDefault.contains(((Viewpoint)object).getName())) {
                    this.viewpoints.add((Viewpoint)object);
                }
                ++i;
            }
            if (!this.viewpoints.isEmpty()) {
                tableViewer.setCheckedElements(this.viewpoints.toArray(new Object[0]));
                tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.viewpoints.get(0)));
            }
        }
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ViewpointsSelectionWizardPage.this.viewpoints.add((Viewpoint)event.getElement());
                } else {
                    ViewpointsSelectionWizardPage.this.viewpoints.remove(event.getElement());
                }
                ViewpointsSelectionWizardPage.this.setPageComplete(ViewpointsSelectionWizardPage.this.isPageComplete());
            }
        });
        this.setControl((Control)this.viewpointsSelectionGraphicalHandler.getRootComposite());
    }

    private Collection<Viewpoint> getAvailableViewpoints() {
        ViewpointRegistry registry = ViewpointRegistry.getInstance();
        return Collections2.filter((Collection)registry.getViewpoints(), (Predicate)new Predicate<Viewpoint>(){

            public boolean apply(Viewpoint viewpoint) {
                for (String ext : ViewpointsSelectionWizardPage.this.computeSemanticFileExtensions(ViewpointsSelectionWizardPage.this.session)) {
                    if (!new ViewpointQuery(viewpoint).handlesSemanticModelExtension(ext)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    protected Collection<String> computeSemanticFileExtensions(Session theSession) {
        return this.viewpointsSelectionGraphicalHandler.computeSemanticFileExtensions(theSession);
    }

    public boolean isCurrentPageOnWizard() {
        return super.isCurrentPage();
    }

    protected void setBrowserInput(Viewpoint viewpoint) {
        this.viewpointsSelectionGraphicalHandler.setBrowserInput(viewpoint);
    }
}

