/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.featureextensions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.featureextensions.FeatureExtension;
import org.eclipse.sirius.business.api.featureextensions.FeatureExtensionsManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DFeatureExtension;
import org.eclipse.sirius.viewpoint.description.FeatureExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class FeatureExtensionsManagerImpl
implements FeatureExtensionsManager {
    Map<String, FeatureExtension> featureExtensions = new HashMap<String, FeatureExtension>();

    public static FeatureExtensionsManager init() {
        FeatureExtensionsManagerImpl manager = new FeatureExtensionsManagerImpl();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List parsedFeatureExtensions = EclipseUtil.getExtensionPlugins(FeatureExtension.class, (String)"org.eclipse.sirius.featureExtensions", (String)"class");
            for (FeatureExtension featureExtension : parsedFeatureExtensions) {
                manager.enableFeatureExtension(featureExtension);
            }
        }
        return manager;
    }

    @Override
    public void disableFeatureExtension(FeatureExtension featureExtension) {
        this.featureExtensions.remove(featureExtension.getName());
    }

    @Override
    public void enableFeatureExtension(FeatureExtension featureExtension) {
        this.featureExtensions.put(featureExtension.getName(), featureExtension);
    }

    @Override
    public <T extends FeatureExtensionDescription> List<T> getFeatureExtensionDescriptions(Viewpoint viewpoint, Class<T> clazz) {
        for (FeatureExtension featureExtension : this.featureExtensions.values()) {
            List<T> perspectives = featureExtension.getServices().getFeatureExtensionDescriptions(viewpoint, clazz);
            if (perspectives == null) continue;
            return perspectives;
        }
        return null;
    }

    @Override
    public void saveFeatureExtensionData(String id, Session session, EObject associatedInstance, DFeatureExtension data) {
        FeatureExtension featureExtension = this.featureExtensions.get(id);
        if (featureExtension != null) {
            featureExtension.getServices().saveFeatureExtensionData(id, session, associatedInstance, data);
        }
    }

    @Override
    public Collection<DFeatureExtension> retrieveFeatureExtensionData(String id, Session session) {
        FeatureExtension featureExtension = this.featureExtensions.get(id);
        if (featureExtension != null) {
            return featureExtension.getServices().retrieveFeatureExtensionData(id, session);
        }
        return null;
    }
}

