/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.view;

import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;

public class SiriusOutlineView {
    private static final int LAYER_TEXT_COLUMN_INDEX = 2;
    private static final int FILTER_TEXT_COLUMN_INDEX = 1;
    private final SWTBotView view;
    private final SWTWorkbenchBot bot;

    public SiriusOutlineView(SWTWorkbenchBot bot, SWTBotView view) {
        this.view = view;
        this.bot = bot;
    }

    public SiriusOutlineView layers() {
        this.view.toolbarToggleButton("Layers").click();
        return this;
    }

    public void activateLayer(String layer) {
        this.activate(layer, 2);
    }

    public SiriusOutlineView filters() {
        this.view.toolbarToggleButton("Filters").click();
        return this;
    }

    public void activateFilter(String filter) {
        this.activate(filter, 1);
    }

    private void activate(String id, int textColumn) {
        SWTBot tableBot = this.view.bot();
        SWTBotTable table = tableBot.table();
        int i = 0;
        while (i < table.rowCount()) {
            int rowPosition = i;
            SWTBotTableItem item = table.getTableItem(rowPosition);
            String text = item.getText(textColumn);
            if (id.equals(text)) {
                table.click(rowPosition, 0);
            }
            ++i;
        }
    }
}

