/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tests.support.api.ICondition;

public class OpenedSessionsCondition
implements ICondition {
    private final int expectedNumber;

    public OpenedSessionsCondition(int expectedNumber) {
        this.expectedNumber = expectedNumber;
    }

    @Override
    public boolean test() throws Exception {
        Collection knownSession = SessionManager.INSTANCE.getSessions();
        Iterable openedSessions = Iterables.filter((Iterable)knownSession, (Predicate)new Predicate<Session>(){

            public boolean apply(Session input) {
                return input.isOpen();
            }
        });
        return this.expectedNumber == Iterables.size((Iterable)openedSessions);
    }

    @Override
    public String getFailureMessage() {
        return "The expected number of session was not reached.";
    }
}

