/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.emf.ecore.EObject;

class QueryAstSerializer
extends AstSwitch<Void> {
    private static final String CLOSING_BRACKET = "}";
    private static final String COMMA = ", ";
    private StringBuilder builder;

    QueryAstSerializer() {
    }

    public String serialize(Expression expression) {
        this.builder = new StringBuilder();
        this.doSwitch(expression);
        return this.builder.toString();
    }

    @Override
    public Void caseBinding(Binding binding) {
        this.builder.append(binding.getName());
        if (binding.getType() != null) {
            this.builder.append(" : ");
            this.builder.append(this.doSwitch(binding.getType()));
        }
        this.builder.append(" = ");
        this.builder.append(this.doSwitch(binding.getValue()));
        return null;
    }

    @Override
    public Void caseBooleanLiteral(BooleanLiteral booleanLiteral) {
        this.builder.append(booleanLiteral.isValue());
        return null;
    }

    @Override
    public Void caseCall(Call call) {
        if (call.getType() == CallType.COLLECTIONCALL) {
            this.builder.append("->");
        } else {
            this.builder.append(".");
        }
        this.builder.append(call.getServiceName());
        this.builder.append("(");
        StringBuilder previousBuilder = this.builder;
        this.builder = new StringBuilder();
        for (Expression argument : call.getArguments()) {
            this.doSwitch(argument);
            this.builder.append(COMMA);
        }
        if (this.builder.length() > 0) {
            previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
        }
        this.builder = previousBuilder;
        this.builder.append(")");
        return null;
    }

    @Override
    public Void caseCollectionTypeLiteral(CollectionTypeLiteral collectionTypeLiteral) {
        if (collectionTypeLiteral.getValue() == List.class) {
            this.builder.append("Sequence(");
        } else if (collectionTypeLiteral.getValue() == Set.class) {
            this.builder.append("OrderedSet(");
        } else {
            this.builder.append("***invalid type of collection ***(");
        }
        this.doSwitch(collectionTypeLiteral.getElementType());
        this.builder.append("");
        return null;
    }

    @Override
    public Void caseConditional(Conditional conditional) {
        this.builder.append("if (");
        this.doSwitch(conditional.getPredicate());
        this.builder.append(") then ");
        this.doSwitch(conditional.getTrueBranch());
        this.builder.append(" else ");
        this.doSwitch(conditional.getFalseBranch());
        this.builder.append(" endif ");
        return null;
    }

    @Override
    public Void caseEnumLiteral(EnumLiteral enumLiteral) {
        this.builder.append(enumLiteral.getLiteral().getEEnum().getEPackage().getName());
        this.builder.append("::");
        this.builder.append(enumLiteral.getLiteral().getEEnum().getName());
        this.builder.append("::");
        this.builder.append(enumLiteral.getLiteral().getName());
        return null;
    }

    @Override
    public Void caseError(Error error) {
        this.builder.append("***ERROR***");
        return null;
    }

    @Override
    public Void caseIntegerLiteral(IntegerLiteral object) {
        this.builder.append(object.getValue());
        return null;
    }

    @Override
    public Void caseLambda(Lambda lambda) {
        this.doSwitch((EObject)lambda.getParameters().get(0));
        this.builder.append(" | ");
        this.doSwitch(lambda.getExpression());
        return null;
    }

    @Override
    public Void caseLet(Let let) {
        this.builder.append("let ");
        StringBuilder previousBuilder = this.builder;
        this.builder = new StringBuilder();
        for (Binding binding : let.getBindings()) {
            this.doSwitch(binding);
            this.builder.append(COMMA);
        }
        previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
        this.builder.append(" in ");
        this.doSwitch(let.getBody());
        return (Void)super.caseLet(let);
    }

    @Override
    public Void caseNullLiteral(NullLiteral nullLiteral) {
        this.builder.append("null");
        return null;
    }

    @Override
    public Void caseSequenceInExtensionLiteral(SequenceInExtensionLiteral sequenceInExtensionLiteral) {
        this.builder.append("Sequence{");
        StringBuilder previousBuilder = this.builder;
        this.builder = new StringBuilder();
        for (Expression value : sequenceInExtensionLiteral.getValues()) {
            this.doSwitch(value);
            this.builder.append(COMMA);
        }
        previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
        this.builder.append(CLOSING_BRACKET);
        return null;
    }

    @Override
    public Void caseRealLiteral(RealLiteral realLiteral) {
        this.builder.append(realLiteral.getValue());
        return null;
    }

    @Override
    public Void caseSetInExtensionLiteral(SetInExtensionLiteral setInExtensionLiteral) {
        this.builder.append("OrderedSet{");
        StringBuilder previousBuilder = this.builder;
        this.builder = new StringBuilder();
        for (Expression value : setInExtensionLiteral.getValues()) {
            this.doSwitch(value);
            this.builder.append(COMMA);
        }
        previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
        this.builder.append(CLOSING_BRACKET);
        return null;
    }

    @Override
    public Void caseStringLiteral(StringLiteral stringLiteral) {
        this.builder.append("'");
        this.builder.append(stringLiteral.getValue());
        this.builder.append("'");
        return null;
    }

    @Override
    public Void caseTypeSetLiteral(TypeSetLiteral typeSetLiteral) {
        this.builder.append("{");
        StringBuilder previousBuilder = this.builder;
        this.builder = new StringBuilder();
        for (TypeLiteral type : typeSetLiteral.getTypes()) {
            this.doSwitch(type);
            this.builder.append(" | ");
        }
        previousBuilder.append(this.builder.substring(0, this.builder.length() - 3));
        this.builder.append(CLOSING_BRACKET);
        return null;
    }

    @Override
    public Void caseVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.builder.append(variableDeclaration.getName());
        if (variableDeclaration.getType() != null) {
            this.builder.append(" : ");
            this.doSwitch(variableDeclaration.getType());
        }
        this.builder.append(" = ");
        this.doSwitch(variableDeclaration.getExpression());
        return null;
    }

    @Override
    public Void caseVarRef(VarRef varRef) {
        this.builder.append(varRef.getVariableName());
        return null;
    }
}

