/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.IToolBarContextService;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarFiller;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.ToolBarContextService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.menus.IMenuService;

public abstract class AbstractTabbarFiller
implements TabbarFiller {
    protected ToolBarManager manager;
    protected IWorkbenchPage page;
    protected IDiagramWorkbenchPart part;
    private boolean disposed;

    public AbstractTabbarFiller(ToolBarManager manager, IWorkbenchPage page) {
        this.manager = manager;
        this.page = page;
    }

    @Override
    public void setPart(IDiagramWorkbenchPart workbenchPart) {
        this.part = workbenchPart;
    }

    @Override
    public void fill() {
        if (!this.isDisposed()) {
            this.doFill();
            this.manager.update(true);
        }
    }

    protected abstract void doFill();

    protected void addSeparator() {
        this.manager.add((IContributionItem)new Separator());
    }

    protected void addSeparator(String groupName) {
        if (StringUtil.isEmpty((String)groupName)) {
            this.addSeparator();
        } else {
            this.manager.add((IContributionItem)new Separator(groupName));
        }
    }

    protected void addTabbarContributions() {
        this.addSeparator("additions");
        ((ToolBarContextService)IToolBarContextService.INSTANCE).setMenuManager(this.manager);
        ((ToolBarContextService)IToolBarContextService.INSTANCE).setPage(this.page);
        ((ToolBarContextService)IToolBarContextService.INSTANCE).setPart(this.part);
        IMenuService menuService = (IMenuService)this.part.getSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)this.manager, "toolbar:org.eclipse.sirius.diagram.ui.tabbar");
        IToolBarContextService.INSTANCE.dispose();
    }

    protected void update(ISelection iSelection) {
    }

    protected void releaseTabbarContributions() {
        IMenuService menuService = (IMenuService)this.part.getSite().getService(IMenuService.class);
        menuService.releaseContributions((ContributionManager)this.manager);
    }

    @Override
    public void dispose() {
        this.manager = null;
        this.page = null;
        this.part = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

