/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.ICreationTask;
import org.eclipse.sirius.business.api.helper.task.TaskExecutor;
import org.eclipse.sirius.business.internal.helper.task.IDeletionTask;
import org.eclipse.sirius.business.internal.helper.task.IModificationTask;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.viewpoint.DRepresentationElement;

public class SiriusCommand
extends RecordingCommand
implements DCommand {
    private static final int CREATED_OBJECTS = 0;
    private static final int CREATED_VIEWS = 1;
    private static final int DELETED_OBJECTS = 2;
    private static final int CREATED_REFERENCES = 3;
    private static final int AFFECTED_ELEMENTS = 4;
    private List<ICommandTask> tasks = new ArrayList<ICommandTask>(5);

    public SiriusCommand(TransactionalEditingDomain domain, String label) {
        super(domain, label);
    }

    public SiriusCommand(TransactionalEditingDomain domain) {
        this(domain, null);
    }

    protected void doExecute() {
        TaskExecutor.execute(this.tasks);
    }

    public boolean canExecute() {
        return TaskExecutor.canExecute(this.tasks);
    }

    @Override
    public List<ICommandTask> getTasks() {
        return this.tasks;
    }

    private Collection<EObject> getOperationsObject(int kind) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (ICommandTask task : this.tasks) {
            this.addOperationsObjects(kind, task, result);
        }
        return result;
    }

    private void addOperationsObjects(int kind, ICommandTask task, Collection<EObject> result) {
        switch (kind) {
            case 0: {
                if (!(task instanceof ICreationTask)) break;
                result.addAll(((ICreationTask)((Object)task)).getCreatedElements());
                break;
            }
            case 1: {
                if (!(task instanceof ICreationTask)) break;
                result.addAll(((ICreationTask)((Object)task)).getCreatedRepresentationElements());
                break;
            }
            case 2: {
                if (!(task instanceof IDeletionTask)) break;
                result.addAll(((IDeletionTask)((Object)task)).getDeletedElements());
                break;
            }
            case 3: {
                if (!(task instanceof IModificationTask)) break;
                result.addAll(((IModificationTask)((Object)task)).getCreatedReferences());
                break;
            }
            case 4: {
                if (!(task instanceof IModificationTask)) break;
                result.addAll(((IModificationTask)((Object)task)).getAffectedElements());
                break;
            }
        }
        for (ICommandTask childTask : task.getChildrenTasks()) {
            this.addOperationsObjects(kind, childTask, result);
        }
    }

    @Override
    public Collection<EObject> getCreatedObjects() {
        return this.getOperationsObject(0);
    }

    @Override
    public Collection<DRepresentationElement> getCreatedRepresentationElements() {
        Collection<EObject> objects = this.getOperationsObject(1);
        ArrayList<DRepresentationElement> elements = new ArrayList<DRepresentationElement>(objects.size());
        for (EObject eObj : objects) {
            if (!(eObj instanceof DRepresentationElement)) continue;
            elements.add((DRepresentationElement)eObj);
        }
        return elements;
    }

    @Override
    public Collection<EObject> getDeletedObjects() {
        return this.getOperationsObject(2);
    }

    @Override
    public Collection<EObject> getCreatedReferences() {
        return this.getOperationsObject(3);
    }

    @Override
    public Collection<EObject> getAffectedElements() {
        return this.getOperationsObject(4);
    }

    @Override
    public EObject getCreatedElement() {
        return this.getCreatedRepresentationElements().isEmpty() ? null : (EObject)this.getCreatedRepresentationElements().iterator().next();
    }
}

