/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.firstiteration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.firstiteration.BestCandidateFilter;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;

public class AspectRatioFilter
implements BestCandidateFilter {
    @Override
    public List<DrawingData> filterList(List<DrawingData> candidates, double aspectRatio) {
        ArrayList<DrawingData> remainingCandidates = new ArrayList<DrawingData>();
        double smallestDeviation = Double.POSITIVE_INFINITY;
        for (DrawingData opt : candidates) {
            smallestDeviation = Math.min(smallestDeviation, Math.abs(opt.getAspectRatio() - aspectRatio));
        }
        for (DrawingData candidate : candidates) {
            if (Math.abs(candidate.getAspectRatio() - aspectRatio) != smallestDeviation) continue;
            remainingCandidates.add(candidate);
        }
        return remainingCandidates;
    }
}

