/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class UserSession {
    private Session session;

    public UserSession(Session session) {
        this.session = session;
    }

    public static UserSession from(Session session) {
        return new UserSession(session);
    }

    public static UserSession from(EObject eObject) {
        Session session;
        EObject modelElement = eObject;
        if (eObject instanceof DSemanticDecorator) {
            modelElement = ((DSemanticDecorator)eObject).getTarget();
        }
        if ((session = SessionManager.INSTANCE.getSession(modelElement)) != null) {
            return UserSession.from(session);
        }
        return null;
    }

    public static UserSession from(ISelection selection) {
        Object o;
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty() && (o = structuredSelection.getFirstElement()) instanceof EObject) {
            EObject eObject = (EObject)o;
            return UserSession.from(eObject);
        }
        return null;
    }

    public boolean isOpen() {
        if (this.session != null) {
            return this.session.isOpen();
        }
        return false;
    }

    public UserSession save(IProgressMonitor pm) {
        this.session.save(pm);
        return this;
    }

    public UserSession close(IProgressMonitor pm) {
        this.session.close(pm);
        return this;
    }

    public UserSession openRepresentation(String name) {
        DRepresentation representation = this.findRepresentationByName(name);
        if (representation != null) {
            this.openEditor(representation, (IProgressMonitor)new NullProgressMonitor());
        } else {
            SiriusEditPlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.UserSession_representationNotFound, name)));
        }
        return this;
    }

    private IEditorPart openEditor(DRepresentation representation, IProgressMonitor monitor) {
        IEditorPart openEditorPart = DialectUIManager.INSTANCE.openEditor(this.session, representation, monitor);
        return openEditorPart;
    }

    public UserSession selectViewpoint(String viewpointName) {
        return this.selectViewpoints(Arrays.asList(viewpointName));
    }

    public UserSession selectOnlyViewpoint(String viewpointName) {
        return this.selectViewpoints((Iterable<String>)Arrays.asList(viewpointName), true);
    }

    public UserSession selectViewpoints(Iterable<String> viewpointNames) {
        return this.selectViewpoints(viewpointNames, false);
    }

    public UserSession selectOnlyViewpoints(Iterable<String> viewpointNames) {
        return this.selectViewpoints(viewpointNames, true);
    }

    private UserSession selectViewpoints(final Iterable<String> viewpointNames, final boolean onlyThisViewpoints) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    LinkedHashSet<Viewpoint> viewpoints = new LinkedHashSet<Viewpoint>();
                    for (String viewpointName : viewpointNames) {
                        Viewpoint viewpoint = UserSession.this.findViewpointByName(viewpointName);
                        viewpoints.add(viewpoint);
                    }
                    UserSession.this.selectViewpoints(viewpoints, onlyThisViewpoints);
                }
            });
        }
        catch (InvocationTargetException e) {
            SiriusEditPlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.UserSession_viewpointSelectionFailed, viewpointNames), (Throwable)e));
        }
        catch (InterruptedException e) {
            SiriusEditPlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.UserSession_viewpointSelectionFailed, viewpointNames), (Throwable)e));
        }
        return this;
    }

    private void selectViewpoints(Collection<Viewpoint> viewpoints, boolean deselectOtherViewpoints) {
        Collection selectedViewpoints = this.session.getSelectedViewpoints(false);
        HashSet<Viewpoint> viewpointsToDeselect = new HashSet<Viewpoint>();
        HashSet<Viewpoint> viewpointsToSelect = new HashSet<Viewpoint>();
        for (Viewpoint viewpoint : viewpoints) {
            Viewpoint vp = SiriusResourceHelper.getCorrespondingViewpoint((Session)this.session, (Viewpoint)viewpoint);
            if (selectedViewpoints.contains(vp)) continue;
            viewpointsToSelect.add(vp);
        }
        if (deselectOtherViewpoints) {
            for (Viewpoint candidate : selectedViewpoints) {
                if (viewpointsToSelect.contains(candidate)) continue;
                viewpointsToDeselect.add(candidate);
            }
        }
        ViewpointSelectionCallback selectionCallback = new ViewpointSelectionCallback();
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(this.session, selectionCallback, viewpointsToSelect, viewpointsToDeselect, (IProgressMonitor)new NullProgressMonitor());
        domain.getCommandStack().execute((Command)command);
    }

    public ECrossReferenceAdapter getSemanticCrossReferencer() {
        return this.session.getSemanticCrossReferencer();
    }

    private DRepresentation findRepresentationByName(String name) {
        Collection allRepresentationDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(this.session);
        for (DRepresentationDescriptor representationDescriptor : allRepresentationDescriptors) {
            if (!representationDescriptor.getName().equals(name)) continue;
            return representationDescriptor.getRepresentation();
        }
        return null;
    }

    private Viewpoint findViewpointByName(String vpName) {
        for (Viewpoint candidate : ViewpointRegistry.getInstance().getViewpoints()) {
            if (!vpName.equals(candidate.getName())) continue;
            return candidate;
        }
        return null;
    }

    public UserSession openRepresentation(ISelection selection) {
        return this.openRepresentation(selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public UserSession openRepresentation(ISelection selection, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.UserSession_openRepresentationTask, 5);
            EObject selected = this.getEObject(selection);
            monitor.worked(1);
            DRepresentation representation = this.findRepresentation(selected);
            if (representation != null) {
                IEditorPart part = this.openEditor(representation, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                monitor.worked(3);
                if (part != null && selected instanceof DSemanticDecorator) {
                    EObject semantic = ((DSemanticDecorator)selected).getTarget();
                    this.updateUISession((DialectEditor)part, semantic);
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
        return this;
    }

    private DRepresentation findRepresentation(EObject element) {
        if (element instanceof DRepresentation) {
            return (DRepresentation)element;
        }
        Collection representations = DialectManager.INSTANCE.getRepresentations(element, this.session);
        return representations.isEmpty() ? null : (DRepresentation)representations.toArray()[0];
    }

    private void updateUISession(DialectEditor part, EObject semantic) {
        if (this.session != null) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(this.session);
            uiSession.open();
            uiSession.attachEditor(part);
        }
    }

    private EObject getEObject(ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return (EObject)element;
        }
        return null;
    }
}

