/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.io.File;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class WorkspacePathValidator
implements IValidator {
    private ControlDecoration controlDecoration;

    public WorkspacePathValidator(ControlDecoration controlDecoration) {
        this.controlDecoration = controlDecoration;
    }

    public IStatus validate(Object value) {
        String text;
        IStatus status = Status.OK_STATUS;
        if (value instanceof String && this.controlDecoration.getControl().isEnabled() && (text = (String)value).trim().length() > 0) {
            Path path = new Path(text);
            File file = FileProvider.getDefault().getFile((IPath)path);
            if (file == null || !file.exists()) {
                this.controlDecoration.show();
                this.controlDecoration.setDescriptionText(Messages.WorkspacePathValidator_invalidPathDecorationDescriptionText);
                status = ValidationStatus.error((String)Messages.WorkspacePathValidator_invalidPahtStatusMessage);
            }
        }
        if (status.isOK()) {
            this.controlDecoration.hide();
        }
        return status;
    }
}

