/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.emf.internal.schema;

import graphql.Scalars;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLFilterStatus;
import org.eclipse.sirius.services.graphql.emf.internal.schema.EEnumTypeBuilder;
import org.eclipse.sirius.services.graphql.emf.internal.schema.EStructuralFeatureScalarTypeBuilder;

public class FieldsBuilder {
    private EClass eClass;
    private HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache;
    private Function<EStructuralFeature, SiriusGraphQLFilterStatus> eStructuralFeatureFilter = eStructuralFeature -> SiriusGraphQLFilterStatus.KEEP;

    public FieldsBuilder(EClass eClass, HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache) {
        this.eClass = eClass;
        this.eDataTypeToOutputTypeCache = eDataTypeToOutputTypeCache;
    }

    public FieldsBuilder eStructuralFeatureFilter(Function<EStructuralFeature, SiriusGraphQLFilterStatus> eStructuralFeatureFilter) {
        this.eStructuralFeatureFilter = eStructuralFeatureFilter;
        return this;
    }

    public List<GraphQLFieldDefinition> getFields() {
        ArrayList<GraphQLFieldDefinition> fields = new ArrayList<GraphQLFieldDefinition>();
        this.eClass.getEAllStructuralFeatures().stream().filter(this::isSupported).map(this::getField).forEach(fields::add);
        return fields;
    }

    private boolean isSupported(EStructuralFeature eStructuralFeature) {
        boolean isSupported = eStructuralFeature instanceof EAttribute;
        isSupported = isSupported && SiriusGraphQLFilterStatus.KEEP == this.eStructuralFeatureFilter.apply(eStructuralFeature);
        isSupported = isSupported && this.getScalar(((EAttribute)eStructuralFeature).getEAttributeType()) != null;
        isSupported = isSupported || eStructuralFeature instanceof EReference;
        return isSupported;
    }

    private GraphQLFieldDefinition getField(EStructuralFeature eStructuralFeature) {
        return GraphQLFieldDefinition.newFieldDefinition().name(eStructuralFeature.getName()).type(this.getType(eStructuralFeature)).build();
    }

    private GraphQLOutputType getType(EStructuralFeature eStructuralFeature) {
        Object type = null;
        if (eStructuralFeature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            type = this.getScalar(eAttribute.getEAttributeType());
            if (Scalars.GraphQLBoolean.equals(type) || Scalars.GraphQLInt.equals(type)) {
                type = new GraphQLNonNull((GraphQLType)type);
            }
        } else if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            type = eReference.isMany() ? new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(eReference.getEReferenceType().getName())))) : new GraphQLTypeReference(eReference.getEReferenceType().getName());
        }
        return type;
    }

    private GraphQLOutputType getScalar(EDataType eDataType) {
        Object type = null;
        type = EcorePackage.eINSTANCE.getEBigDecimal().equals(eDataType) ? Scalars.GraphQLBigDecimal : (EcorePackage.eINSTANCE.getEBigInteger().equals(eDataType) ? Scalars.GraphQLBigInteger : (EcorePackage.eINSTANCE.getEBoolean().equals(eDataType) ? Scalars.GraphQLBoolean : (EcorePackage.eINSTANCE.getEByte().equals(eDataType) ? Scalars.GraphQLByte : (EcorePackage.eINSTANCE.getEChar().equals(eDataType) ? Scalars.GraphQLChar : (EcorePackage.eINSTANCE.getEFloat().equals(eDataType) ? Scalars.GraphQLFloat : (EcorePackage.eINSTANCE.getEInt().equals(eDataType) ? Scalars.GraphQLInt : (EcorePackage.eINSTANCE.getELong().equals(eDataType) ? Scalars.GraphQLLong : (EcorePackage.eINSTANCE.getEShort().equals(eDataType) ? Scalars.GraphQLShort : (EcorePackage.eINSTANCE.getEString().equals(eDataType) ? Scalars.GraphQLString : this.eDataTypeToOutputTypeCache.computeIfAbsent(eDataType, dataType -> {
            GraphQLEnumType graphQLOutputType = null;
            if (dataType instanceof EEnum) {
                EEnum eEnum = (EEnum)dataType;
                graphQLOutputType = new EEnumTypeBuilder(eEnum).getType();
            } else if (dataType.isSerializable()) {
                graphQLOutputType = new EStructuralFeatureScalarTypeBuilder(eDataType).getType();
            }
            return graphQLOutputType;
        }))))))))));
        return type;
    }
}

