/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.api.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramNode;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramLabel;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramRGBColor;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramColorConverter;

public final class SiriusDiagramListNode
extends AbstractSiriusDiagramNode {
    private static final String TYPE = "node:listflatcontainer";
    private SiriusDiagramLabel label;
    private SiriusDiagramRGBColor backgroundColor;
    private SiriusDiagramRGBColor borderColor;
    private int borderSize;
    private String imagePath;
    private List<AbstractSiriusDiagramElement> ports = new ArrayList<AbstractSiriusDiagramElement>();

    private SiriusDiagramListNode(String identifier, String semanticElementIdentifier) {
        super(identifier, semanticElementIdentifier, TYPE);
    }

    public SiriusDiagramRGBColor getBackgroundColor() {
        return this.backgroundColor;
    }

    private void setBackgroundColor(SiriusDiagramRGBColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public SiriusDiagramRGBColor getBorderColor() {
        return this.borderColor;
    }

    private void setBorderColor(SiriusDiagramRGBColor borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    private void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    private void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public SiriusDiagramLabel getLabel() {
        return this.label;
    }

    private void setLabel(SiriusDiagramLabel label) {
        this.label = label;
    }

    public List<AbstractSiriusDiagramElement> getPorts() {
        return this.ports;
    }

    public static Builder newListNode(String identifier, String semanticElementIdentifier) {
        return new Builder(identifier, semanticElementIdentifier);
    }

    /* synthetic */ SiriusDiagramListNode(String string, String string2, SiriusDiagramListNode siriusDiagramListNode) {
        this(string, string2);
    }

    public static final class Builder {
        private String identifier;
        private String semanticElementIdentifier;
        private SiriusDiagramRGBColor backgroundColor = SiriusDiagramColorConverter.DEFAULT_COLOR;
        private SiriusDiagramRGBColor borderColor = SiriusDiagramColorConverter.DEFAULT_COLOR;
        private int borderSize = 1;
        private SiriusDiagramLabel label;
        private String imagePath;
        private List<AbstractSiriusDiagramElement> ports;
        private List<AbstractSiriusDiagramElement> children = new ArrayList<AbstractSiriusDiagramElement>();

        private Builder(String identifier, String semanticElementIdentifier) {
            this.identifier = Objects.requireNonNull(identifier);
            this.semanticElementIdentifier = Objects.requireNonNull(semanticElementIdentifier);
        }

        public Builder backgroundColor(SiriusDiagramRGBColor backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder bordercolor(SiriusDiagramRGBColor borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public Builder borderSize(int borderSize) {
            this.borderSize = borderSize;
            return this;
        }

        public Builder label(SiriusDiagramLabel label) {
            this.label = label;
            return this;
        }

        public Builder imagePath(String imagePath) {
            this.imagePath = imagePath;
            return this;
        }

        public Builder ports(List<AbstractSiriusDiagramElement> ports) {
            this.ports = Objects.requireNonNull(ports);
            return this;
        }

        public Builder withChildren(List<AbstractSiriusDiagramElement> children) {
            this.children = Objects.requireNonNull(children);
            return this;
        }

        public SiriusDiagramListNode build() {
            SiriusDiagramListNode listNode = new SiriusDiagramListNode(this.identifier, this.semanticElementIdentifier, null);
            listNode.setBackgroundColor(this.backgroundColor);
            listNode.setBorderColor(this.borderColor);
            listNode.setBorderSize(this.borderSize);
            listNode.setImagePath(this.imagePath);
            listNode.setLabel(this.label);
            listNode.getPorts().addAll(this.ports);
            listNode.getChildren().addAll(this.children);
            return listNode;
        }
    }
}

