/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.command;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.FixGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshSemanticOrderingsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetVerticalRangeOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SynchronizeISequenceEventsSemanticOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.VerticalSpaceExpansionOrReduction;
import org.eclipse.sirius.diagram.sequence.business.internal.util.DecreasingRange;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ExecutionOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.OperandEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.tools.internal.command.UndoRedoCapableEMFCommandFactory;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;

public final class SequenceEMFCommandFactory
extends UndoRedoCapableEMFCommandFactory {
    private final SequenceDiagramEditPart sdep;

    public SequenceEMFCommandFactory(SequenceDiagramEditPart sdep) {
        super(sdep.getEditingDomain());
        this.sdep = sdep;
    }

    public Command buildDeleteDiagramElement(DDiagramElement element) {
        Object part;
        Command result = super.buildDeleteDiagramElement(element);
        if (AbstractNodeEvent.viewpointElementPredicate().apply((Object)element)) {
            Object part2 = this.sdep.getViewer().getEditPartRegistry().get(element);
            if (part2 instanceof ExecutionEditPart) {
                ExecutionEditPart executionPart = (ExecutionEditPart)part2;
                result = this.getDeleteExecutionCommand(executionPart, result);
            }
        } else if (Operand.viewpointElementPredicate().apply((Object)element) && (part = this.sdep.getViewer().getEditPartRegistry().get(element)) instanceof OperandEditPart) {
            OperandEditPart operandPart = (OperandEditPart)part;
            result = this.getDeleteOperandCommand(operandPart, result);
        }
        return result;
    }

    public Command buildInsertOrRemoveVerticalBlankSpaceCommand(DDiagram diagram, int startY, int spaceToInsertOrRemove) {
        if (spaceToInsertOrRemove < 0) {
            return CommandFactory.createRecordingCommand((TransactionalEditingDomain)this.sdep.getEditingDomain(), (AbstractModelChangeOperation)new VerticalSpaceExpansionOrReduction(this.sdep.getSequenceDiagram(), (Range)new DecreasingRange(startY, startY + spaceToInsertOrRemove), Integer.valueOf(0), Collections.emptyList()));
        }
        return CommandFactory.createRecordingCommand((TransactionalEditingDomain)this.sdep.getEditingDomain(), (AbstractModelChangeOperation)new VerticalSpaceExpansionOrReduction(this.sdep.getSequenceDiagram(), new Range(startY, startY + spaceToInsertOrRemove), Integer.valueOf(0), Collections.emptyList()));
    }

    public Command buildBringToFrontCommand(List<? extends View> elementsToBringToFront) {
        throw new UnsupportedOperationException(Messages.SequenceEMFCommandFactory_notSupportedZorderCommandsMessage);
    }

    public Command buildSendToBackCommand(List<? extends View> elementsToSendToBack) {
        throw new UnsupportedOperationException(Messages.SequenceEMFCommandFactory_notSupportedZorderCommandsMessage);
    }

    public Command buildBringForwardCommand(List<? extends View> elementsToBringForward, int index) {
        throw new UnsupportedOperationException(Messages.SequenceEMFCommandFactory_notSupportedZorderCommandsMessage);
    }

    public Command buildSendBackwardCommand(List<? extends View> elementsToSendBackward, int index) {
        throw new UnsupportedOperationException(Messages.SequenceEMFCommandFactory_notSupportedZorderCommandsMessage);
    }

    private Command getDeleteExecutionCommand(ExecutionEditPart executionPart, Command basicDelete) {
        TransactionalEditingDomain ted = this.sdep.getEditingDomain();
        CompoundCommand cc = new CompoundCommand();
        cc.append(ExecutionOperations.getReconnectSubExecutionsToParentCommand(executionPart));
        cc.append(ExecutionOperations.getReconnectEdgesToParentCommand(executionPart));
        cc.append(basicDelete);
        cc.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)ted, (AbstractModelChangeOperation)new RefreshSemanticOrderingsOperation((SequenceDDiagram)this.sdep.resolveSemanticElement())));
        cc.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)ted, (AbstractModelChangeOperation)new FixGraphicalOrderingOperation((SequenceDDiagram)this.sdep.resolveSemanticElement())));
        return cc;
    }

    private Command getDeleteOperandCommand(OperandEditPart operandPart, Command basicDelete) {
        if (operandPart.getViewer().getSelectedEditParts().contains(operandPart.getParentCombinedFragmentEditPart())) {
            return IdentityCommand.INSTANCE;
        }
        return this.buildDeleteOperandCommand(operandPart, basicDelete);
    }

    private Command buildDeleteOperandCommand(OperandEditPart operandPart, Command basicDelete) {
        TransactionalEditingDomain ted = this.sdep.getEditingDomain();
        CompoundCommand cc = new CompoundCommand();
        cc.append(basicDelete);
        Operand deletedOperand = (Operand)operandPart.getISequenceEvent();
        if (deletedOperand.getCombinedFragment().getOperands().size() == 1 || operandPart.getViewer().getSelectedEditParts().size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Option<Operand> absorbingOperand = this.getAbsorbingOperand(deletedOperand);
        assert (absorbingOperand.some());
        if (absorbingOperand.some()) {
            Range expandedRange = ((Operand)absorbingOperand.get()).getVerticalRange().union(deletedOperand.getVerticalRange());
            cc.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)ted, (AbstractModelChangeOperation)new SetVerticalRangeOperation((ISequenceEvent)absorbingOperand.get(), expandedRange)));
            cc.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)ted, (AbstractModelChangeOperation)new RefreshSemanticOrderingsOperation((SequenceDDiagram)this.sdep.resolveSemanticElement())));
            cc.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)ted, (AbstractModelChangeOperation)new RefreshGraphicalOrderingOperation(this.sdep.getSequenceDiagram())));
            cc.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)ted, (AbstractModelChangeOperation)new SynchronizeISequenceEventsSemanticOrderingOperation((ISequenceEvent)absorbingOperand.get())));
        }
        return cc;
    }

    private Option<Operand> getAbsorbingOperand(Operand deletedOperand) {
        assert (deletedOperand != null);
        if (deletedOperand.isFirstOperand()) {
            return deletedOperand.getFollowingOperand();
        }
        return deletedOperand.getPreviousOperand();
    }
}

