/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.internal.gridcolumngroupkit.GridColumnGroupLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class GridColumnGroup
extends Item {
    private static final int CHEVRON_HEIGHT = 16;
    private static final int CHEVRON_WIDTH = 12;
    private static final int MARGIN_IMAGE = 3;
    private Grid parent;
    private List<GridColumn> columns = new ArrayList<GridColumn>();
    private boolean expanded = true;
    private Font headerFont;
    private boolean headerWordWrap;

    public GridColumnGroup(Grid parent, int style) {
        super((Widget)parent, style);
        this.parent = parent;
        parent.newColumnGroup(this);
    }

    public void dispose() {
        super.dispose();
        if (!this.parent.isDisposing()) {
            GridColumn[] oldColumns = this.columns.toArray(new GridColumn[this.columns.size()]);
            this.columns.clear();
            int i = 0;
            while (i < oldColumns.length) {
                oldColumns[i].dispose();
                ++i;
            }
            this.parent.removeColumnGroup(this);
        }
    }

    public Grid getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(17, (Listener)typedListener);
        this.addListener(18, (Listener)typedListener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(17, (SWTEventListener)listener);
        this.removeListener(18, (SWTEventListener)listener);
    }

    public GridColumn[] getColumns() {
        this.checkWidget();
        return this.columns.toArray(new GridColumn[this.columns.size()]);
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        if (this.expanded != expanded) {
            this.expanded = expanded;
            if (this.parent.getCellSelectionEnabled()) {
                ArrayList<Integer> collapsedCols = new ArrayList<Integer>();
                int j = 0;
                while (j < this.columns.size()) {
                    GridColumn column = this.columns.get(j);
                    if (expanded && column.isSummary()) {
                        collapsedCols.add(this.parent.indexOf(column));
                    }
                    if (!expanded && !column.isSummary()) {
                        collapsedCols.add(this.parent.indexOf(column));
                    }
                    ++j;
                }
                Point[] selection = this.parent.getCellSelection();
                int i = 0;
                while (i < selection.length) {
                    if (collapsedCols.contains(selection[i].x)) {
                        this.parent.deselectCell(selection[i]);
                    }
                    ++i;
                }
            }
            this.parent.invalidateScrollBars();
            this.parent.redraw();
        }
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public Font getHeaderFont() {
        this.checkWidget();
        return this.headerFont == null ? this.parent.getFont() : this.headerFont;
    }

    public void setHeaderFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.headerFont = font;
        this.parent.layoutCache.invalidateHeaderHeight();
        this.parent.scheduleRedraw();
    }

    public void setText(String text) {
        super.setText(text);
        this.parent.layoutCache.invalidateHeaderHeight();
        this.parent.scheduleRedraw();
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.parent.layoutCache.invalidateHeaderHeight();
        this.parent.scheduleRedraw();
    }

    public void setHeaderWordWrap(boolean wordWrap) {
        this.checkWidget();
        this.headerWordWrap = wordWrap;
        this.parent.layoutCache.invalidateHeaderHeight();
        this.parent.scheduleRedraw();
    }

    public boolean getHeaderWordWrap() {
        this.checkWidget();
        return this.headerWordWrap;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)((Object)GridColumnGroupLCA.INSTANCE);
        }
        return (T)super.getAdapter(adapter);
    }

    void newColumn(GridColumn column) {
        this.columns.add(column);
    }

    void removeColumn(GridColumn column) {
        this.columns.remove((Object)column);
    }

    int getNewColumnIndex() {
        int result = -1;
        if (this.columns.size() != 0) {
            GridColumn lastColumn = this.columns.get(this.columns.size() - 1);
            result = this.parent.indexOf(lastColumn) + 1;
        }
        return result;
    }

    int getChevronHeight() {
        return (this.getStyle() & 2) != 0 ? 16 : 0;
    }

    int getHeaderWrapWidth() {
        BoxDimensions headerPadding = this.parent.getHeaderPadding();
        int result = this.getGroupWidth() - headerPadding.left - headerPadding.right;
        Image headerImage = this.getImage();
        if (headerImage != null) {
            result -= headerImage.getBounds().width;
            result -= 3;
        }
        return result -= (this.getStyle() & 2) != 0 ? 12 : 0;
    }

    private int getGroupWidth() {
        int width = 0;
        for (GridColumn column : this.columns) {
            if (!column.isVisible()) continue;
            width += column.getWidth();
        }
        return width;
    }
}

