/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.properties;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.osgi.test.common.annotation.Property;

public class PropertiesConverter {
    public static Dictionary<String, Object> of(ExtensionContext context, Property[] entrys) {
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        for (Property entry : entrys) {
            ((Dictionary)dictionary).put(entry.key(), PropertiesConverter.toValue(context, entry));
        }
        return dictionary;
    }

    private static Object toValue(ExtensionContext context, Property entry) {
        boolean primitive = entry.type().equals((Object)Property.Type.PrimitiveArray);
        String[] value = PropertiesConverter.getRawValue(context, entry.value(), entry.source(), entry.type());
        Object[] templateParams = Arrays.stream(entry.templateArguments()).map(ta -> PropertiesConverter.convertScalar(ta.scalar(), PropertiesConverter.getRawValue(context, ta.value(), ta.source(), Property.Type.Scalar)[0])).toArray();
        Object result = PropertiesConverter.createArray(entry.scalar(), primitive, value.length);
        int i = 0;
        for (String v : value) {
            if (v != null && templateParams.length > 0) {
                v = String.format(v, templateParams);
            }
            Object val = PropertiesConverter.convertScalar(entry.scalar(), v);
            if (Property.Type.Scalar.equals((Object)entry.type())) {
                result = val;
                break;
            }
            Array.set(result, i++, val);
        }
        switch (entry.type()) {
            case Array: {
                return result;
            }
            case PrimitiveArray: {
                return result;
            }
            case Scalar: {
                return result;
            }
            case Collection: {
                return Arrays.asList((Object[])result);
            }
        }
        throw new RuntimeException("conversion error - unknown type");
    }

    private static Object convertScalar(Property.Scalar scalar, String v) {
        if (v != null) {
            switch (scalar) {
                case Boolean: {
                    return Boolean.valueOf(v);
                }
                case Byte: {
                    return Byte.valueOf(v);
                }
                case Character: {
                    return Character.valueOf(v.charAt(0));
                }
                case Double: {
                    return Double.valueOf(v);
                }
                case Float: {
                    return Float.valueOf(v);
                }
                case Integer: {
                    return Integer.valueOf(v);
                }
                case Long: {
                    return Long.valueOf(v);
                }
                case Short: {
                    return Short.valueOf(v);
                }
                case String: {
                    return v;
                }
            }
        }
        return null;
    }

    private static String[] getRawValue(ExtensionContext context, String[] value, Property.ValueSource source, Property.Type type) {
        String[] stringArray;
        String prop = null;
        switch (source) {
            case EnvironmentVariable: {
                if (value.length == 0) {
                    throw new RuntimeException("A property name must be supplied for source EnvironmentVariable");
                }
                if (!System.getenv().containsKey(value[0])) {
                    if (value.length == 1) {
                        throw new RuntimeException("There is no environment variable for name " + value[0]);
                    }
                    prop = value[1];
                    break;
                }
                prop = System.getenv(value[0]);
                break;
            }
            case SystemProperty: {
                if (value.length == 0) {
                    throw new RuntimeException("A property name must be supplied for source SystemProperty");
                }
                if (!System.getProperties().containsKey(value[0])) {
                    if (value.length == 1) {
                        throw new RuntimeException("There is no system property for name " + value[0]);
                    }
                    prop = value[1];
                    break;
                }
                prop = System.getProperty(value[0]);
                break;
            }
            case TestClass: {
                if (context == null) {
                    throw new RuntimeException("No ExtensionContext available to discover the test class");
                }
                return new String[]{context.getRequiredTestClass().getName()};
            }
            case TestMethod: {
                if (context == null) {
                    throw new RuntimeException("No ExtensionContext available to discover the test method");
                }
                return new String[]{context.getRequiredTestMethod().getName()};
            }
            case TestUniqueId: {
                if (context == null) {
                    throw new RuntimeException("No ExtensionContext available to discover the test unique id");
                }
                return new String[]{context.getUniqueId()};
            }
            case Value: {
                return value;
            }
            default: {
                throw new RuntimeException("conversion error - unknown source");
            }
        }
        if (type == Property.Type.Scalar) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prop;
        } else {
            stringArray = prop.split("\\s*,\\s*");
        }
        return stringArray;
    }

    private static Object createArray(Property.Scalar scalar, boolean primitive, int length) {
        switch (scalar) {
            case Boolean: {
                if (primitive) {
                    return new boolean[length];
                }
                return new Boolean[length];
            }
            case Byte: {
                if (primitive) {
                    return new byte[length];
                }
                return new Byte[length];
            }
            case Character: {
                if (primitive) {
                    return new char[length];
                }
                return new Character[length];
            }
            case Double: {
                if (primitive) {
                    return new double[length];
                }
                return new Double[length];
            }
            case Float: {
                if (primitive) {
                    return new int[length];
                }
                return new Float[length];
            }
            case Integer: {
                if (primitive) {
                    return new int[length];
                }
                return new Integer[length];
            }
            case Long: {
                if (primitive) {
                    return new long[length];
                }
                return new Long[length];
            }
            case Short: {
                if (primitive) {
                    return new short[length];
                }
                return new Short[length];
            }
            case String: {
                if (primitive) {
                    throw new IllegalArgumentException("@Property Could not be Scalar=String and type=primitiveArray at the same time");
                }
                return new String[length];
            }
        }
        throw new RuntimeException("conversion error - unknown type");
    }
}

