/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.editors;

import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;

public class JavascriptUtil {
    private static final String OPEN_BRACKET = "[";
    private static final String CLOSE_BRACKET = "]";
    private static final String ID_CHARS_REGEX = "\\p{L}_$\\d";
    private static final String QUALIFIED_ID_CHARS_REGEX = "\\p{L}_$\\d\\.\\[\\]";
    public static final Pattern ID_PATTERN = Pattern.compile("[\\p{L}_$\\d]");
    public static final Pattern QUALIFIED_ID_PATTERN = Pattern.compile("[\\p{L}_$\\d\\.\\[\\]]");

    public static boolean isJsIdentifierCharacter(char ch, boolean qualified) {
        return qualified ? QUALIFIED_ID_PATTERN.matcher(String.valueOf(ch)).find() : ID_PATTERN.matcher(String.valueOf(ch)).find();
    }

    public static String extractSurroundingJsIdentifier(IDocument document, int offset) {
        IRegion region = JavascriptUtil.getSurroundingIdentifierRegion(document, offset, true);
        try {
            return region == null ? null : document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            ChromiumDebugPlugin.log((Throwable)e);
            return null;
        }
    }

    public static IRegion getSurroundingIdentifierRegion(IDocument doc, int offset, boolean qualified) {
        int end;
        int start;
        block12: {
            if (doc == null) {
                return null;
            }
            try {
                int squareBrackets = 0;
                char ch = doc.getChar(offset);
                if (!JavascriptUtil.isJsIdentifierCharacter(ch, qualified) && offset > 0) {
                    --offset;
                }
                start = offset;
                end = offset;
                int goodStart = offset;
                while (start >= 0) {
                    ch = doc.getChar(start);
                    if (!JavascriptUtil.isJsIdentifierCharacter(ch, qualified)) break;
                    if (ch == '[') {
                        --squareBrackets;
                    } else if (ch == ']') {
                        ++squareBrackets;
                    }
                    if (squareBrackets < 0) break;
                    goodStart = start--;
                }
                start = goodStart;
                int length = doc.getLength();
                while (end < length) {
                    try {
                        ch = doc.getChar(end);
                        if (!JavascriptUtil.isJsIdentifierCharacter(ch, false)) break;
                        ++end;
                    }
                    catch (BadLocationException e) {
                        ChromiumDebugPlugin.log((Throwable)e);
                    }
                }
                if (start < end) break block12;
                return null;
            }
            catch (BadLocationException e) {
                ChromiumDebugPlugin.log((Throwable)e);
                return null;
            }
        }
        return new Region(start, end - start);
    }

    private JavascriptUtil() {
    }
}

