/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ColorButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ColorPalette;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.pagedesigner.ui.dialogs.ColorUtil;
import org.eclipse.jst.pagedesigner.ui.dialogs.DialogsMessages;
import org.eclipse.jst.pagedesigner.ui.dialogs.IStyleConstants;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class TextPreferencePage
extends PreferencePage {
    private CSSPropertyContext _style;
    private StyleCombo _fontFamilyCombo;
    private StyleCombo _fontSizeNumberCombo;
    private StyleCombo _fontSizeUnitCombo;
    private StyleCombo _fontWeightCombo;
    private StyleCombo _fontStyleCombo;
    private StyleCombo _fontVariantCombo;
    private StyleCombo _fontLineHeightNumberCombo;
    private StyleCombo _fontLineHeightUnitCombo;
    private StyleCombo _textTransformCombo;
    private ColorButtonDialogField _colorField;
    private Button _textDecorationUnderlineButton;
    private Button _textDecorationOverlineButton;
    private Button _textDecorationLineThroughButton;
    private Button _textDecorationBlinkButton;
    private Button _textDecorationNoneButton;

    public TextPreferencePage(IDOMElement element, CSSPropertyContext style) {
        this._style = style;
        this.setTitle(DialogsMessages.getString("TextPreferencePage.Title"));
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(5, false);
        GridData data = new GridData(1808);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)data);
        Label fontLabel = new Label(top, 0);
        fontLabel.setText(DialogsMessages.getString("TextPreferencePage.Font"));
        data = new GridData(128);
        fontLabel.setLayoutData((Object)data);
        this._fontFamilyCombo = new StyleCombo(top, 0);
        this._fontFamilyCombo.setItems(IStyleConstants.FONT_FAMILY);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this._fontFamilyCombo.setLayoutData(data);
        this._fontFamilyCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextPreferencePage.this._style.setFontFamily(TextPreferencePage.this._fontFamilyCombo.getText());
            }
        });
        Label sizeLabel = new Label(top, 0);
        sizeLabel.setText(DialogsMessages.getString("TextPreferencePage.Size"));
        data = new GridData(128);
        sizeLabel.setLayoutData((Object)data);
        this._fontSizeNumberCombo = new StyleCombo(top, 0);
        this._fontSizeNumberCombo.setItems(IStyleConstants.FONT_SIZE_NUMBER);
        data = new GridData(768);
        this._fontSizeNumberCombo.setLayoutData(data);
        this._fontSizeNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextPreferencePage.this._fontSizeUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(TextPreferencePage.this._fontSizeNumberCombo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    TextPreferencePage.this._fontSizeUnitCombo.setEnabled(false);
                }
                Object size = TextPreferencePage.this._fontSizeNumberCombo.getText();
                if (TextPreferencePage.this._fontSizeUnitCombo.isEnabled()) {
                    size = (String)size + TextPreferencePage.this._fontSizeUnitCombo.getText();
                }
                TextPreferencePage.this._style.setFontSize((String)size);
            }
        });
        this._fontSizeUnitCombo = new StyleCombo(top, 8);
        this._fontSizeUnitCombo.setItems(IStyleConstants.SIZE_UNIT);
        data = new GridData(768);
        this._fontSizeUnitCombo.setLayoutData(data);
        this._fontSizeUnitCombo.select(0);
        this._fontSizeUnitCombo.setEnabled(false);
        this._fontSizeUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object size = TextPreferencePage.this._fontSizeNumberCombo.getText();
                if (TextPreferencePage.this._fontSizeUnitCombo.isEnabled()) {
                    size = (String)size + TextPreferencePage.this._fontSizeUnitCombo.getText();
                }
                TextPreferencePage.this._style.setFontSize((String)size);
            }
        });
        Label weightLabel = new Label(top, 0);
        weightLabel.setText(DialogsMessages.getString("TextPreferencePage.Weight"));
        data = new GridData(128);
        weightLabel.setLayoutData((Object)data);
        this._fontWeightCombo = new StyleCombo(top, 0);
        this._fontWeightCombo.setItems(IStyleConstants.FONT_WEIGHT);
        data = new GridData(768);
        this._fontWeightCombo.setLayoutData(data);
        this._fontWeightCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String weight = TextPreferencePage.this._fontWeightCombo.getText();
                TextPreferencePage.this._style.setFontWeight(weight);
            }
        });
        Label stylesLabel = new Label(top, 0);
        stylesLabel.setText(DialogsMessages.getString("TextPreferencePage.Style"));
        data = new GridData(128);
        stylesLabel.setLayoutData((Object)data);
        this._fontStyleCombo = new StyleCombo(top, 0);
        this._fontStyleCombo.setItems(IStyleConstants.FONT_STYLE);
        data = new GridData(768);
        this._fontStyleCombo.setLayoutData(data);
        this._fontStyleCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String style = TextPreferencePage.this._fontStyleCombo.getText();
                TextPreferencePage.this._style.setFontStyle(style);
            }
        });
        new Label(top, 0);
        Label variantLabel = new Label(top, 0);
        variantLabel.setText(DialogsMessages.getString("TextPreferencePage.Variant"));
        data = new GridData(128);
        variantLabel.setLayoutData((Object)data);
        this._fontVariantCombo = new StyleCombo(top, 0);
        this._fontVariantCombo.setItems(IStyleConstants.FONT_VARIANT);
        data = new GridData(768);
        this._fontVariantCombo.setLayoutData(data);
        this._fontVariantCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String variant = TextPreferencePage.this._fontVariantCombo.getText();
                TextPreferencePage.this._style.setFontVariant(variant);
            }
        });
        Label lineHeightLabel = new Label(top, 0);
        lineHeightLabel.setText(DialogsMessages.getString("TextPreferencePage.LineHeight"));
        data = new GridData(128);
        lineHeightLabel.setLayoutData((Object)data);
        this._fontLineHeightNumberCombo = new StyleCombo(top, 0);
        this._fontLineHeightNumberCombo.setItems(IStyleConstants.NORMAL);
        data = new GridData(768);
        this._fontLineHeightNumberCombo.setLayoutData(data);
        this._fontLineHeightNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextPreferencePage.this._fontLineHeightUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(TextPreferencePage.this._fontLineHeightNumberCombo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    TextPreferencePage.this._fontLineHeightUnitCombo.setEnabled(false);
                }
                Object height = TextPreferencePage.this._fontLineHeightNumberCombo.getText();
                if (TextPreferencePage.this._fontLineHeightUnitCombo.isEnabled()) {
                    height = (String)height + TextPreferencePage.this._fontLineHeightUnitCombo.getText();
                }
                TextPreferencePage.this._style.setLineHeight((String)height);
            }
        });
        this._fontLineHeightUnitCombo = new StyleCombo(top, 8);
        this._fontLineHeightUnitCombo.setItems(IStyleConstants.SIZE_UNIT);
        data = new GridData(768);
        this._fontLineHeightUnitCombo.setLayoutData(data);
        this._fontLineHeightUnitCombo.select(0);
        this._fontLineHeightUnitCombo.setEnabled(false);
        this._fontLineHeightUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object height = TextPreferencePage.this._fontLineHeightNumberCombo.getText();
                if (TextPreferencePage.this._fontLineHeightUnitCombo.isEnabled()) {
                    height = (String)height + TextPreferencePage.this._fontLineHeightUnitCombo.getText();
                }
                TextPreferencePage.this._style.setLineHeight((String)height);
            }
        });
        Label caseLabel = new Label(top, 0);
        caseLabel.setText(DialogsMessages.getString("TextPreferencePage.Case"));
        data = new GridData(128);
        caseLabel.setLayoutData((Object)data);
        this._textTransformCombo = new StyleCombo(top, 0);
        this._textTransformCombo.setItems(IStyleConstants.FONT_TEXTTRANSFORM);
        data = new GridData(768);
        this._textTransformCombo.setLayoutData(data);
        this._textTransformCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textTransform = TextPreferencePage.this._textTransformCombo.getText();
                TextPreferencePage.this._style.setTextTransform(textTransform);
            }
        });
        Label decorationLabel = new Label(top, 0);
        decorationLabel.setText(DialogsMessages.getString("TextPreferencePage.Decoration"));
        data = new GridData(128);
        decorationLabel.setLayoutData((Object)data);
        Composite decorationComposite = new Composite(top, 0);
        data = new GridData(768);
        data.horizontalSpan = 4;
        decorationComposite.setLayoutData((Object)data);
        layout = new GridLayout(5, true);
        layout.marginWidth = 0;
        decorationComposite.setLayout((Layout)layout);
        this._textDecorationUnderlineButton = new Button(decorationComposite, 32);
        this._textDecorationUnderlineButton.setText(IStyleConstants.TEXT_DECORATION[0]);
        this._textDecorationUnderlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextPreferencePage.this._textDecorationUnderlineButton.getSelection()) {
                    TextPreferencePage.this._textDecorationNoneButton.setSelection(false);
                }
                TextPreferencePage.this._style.setTextDecoration(TextPreferencePage.this.getTextDecoration());
            }
        });
        this._textDecorationOverlineButton = new Button(decorationComposite, 32);
        this._textDecorationOverlineButton.setText(IStyleConstants.TEXT_DECORATION[1]);
        this._textDecorationOverlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextPreferencePage.this._textDecorationOverlineButton.getSelection()) {
                    TextPreferencePage.this._textDecorationNoneButton.setSelection(false);
                }
                TextPreferencePage.this._style.setTextDecoration(TextPreferencePage.this.getTextDecoration());
            }
        });
        this._textDecorationLineThroughButton = new Button(decorationComposite, 32);
        this._textDecorationLineThroughButton.setText(IStyleConstants.TEXT_DECORATION[2]);
        this._textDecorationLineThroughButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextPreferencePage.this._textDecorationLineThroughButton.getSelection()) {
                    TextPreferencePage.this._textDecorationNoneButton.setSelection(false);
                }
                TextPreferencePage.this._style.setTextDecoration(TextPreferencePage.this.getTextDecoration());
            }
        });
        this._textDecorationBlinkButton = new Button(decorationComposite, 32);
        this._textDecorationBlinkButton.setText(IStyleConstants.TEXT_DECORATION[3]);
        this._textDecorationBlinkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextPreferencePage.this._textDecorationBlinkButton.getSelection()) {
                    TextPreferencePage.this._textDecorationNoneButton.setSelection(false);
                }
                TextPreferencePage.this._style.setTextDecoration(TextPreferencePage.this.getTextDecoration());
            }
        });
        this._textDecorationNoneButton = new Button(decorationComposite, 32);
        this._textDecorationNoneButton.setText(IStyleConstants.TEXT_DECORATION[4]);
        this._textDecorationNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextPreferencePage.this._textDecorationNoneButton.getSelection()) {
                    TextPreferencePage.this._textDecorationUnderlineButton.setSelection(false);
                    TextPreferencePage.this._textDecorationOverlineButton.setSelection(false);
                    TextPreferencePage.this._textDecorationLineThroughButton.setSelection(false);
                    TextPreferencePage.this._textDecorationBlinkButton.setSelection(false);
                }
                TextPreferencePage.this._style.setTextDecoration(TextPreferencePage.this.getTextDecoration());
            }
        });
        this._colorField = new ColorButtonDialogField(2048, (ColorPalette)new ColorUtil());
        this._colorField.setLabelText(DialogsMessages.getString("TextPreferencePage.Color"));
        data = new GridData(128);
        this._colorField.getLabelControl(null, top).setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        this._colorField.getComboControl(null, top).setLayoutData((Object)data);
        data = new GridData();
        this._colorField.getChangeControl(null, top).setLayoutData((Object)data);
        this._colorField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String color = TextPreferencePage.this._colorField.getText();
                TextPreferencePage.this._style.setColor(color);
            }
        });
        this.initializeControls();
        return top;
    }

    private void initializeControls() {
        String color;
        String textDecoration;
        String textTransform;
        String lineHeight;
        String fontVariant;
        String fontStyle;
        String fontWeight;
        String fontSize;
        String fontFamily = this._style.getFontFamily();
        if (!this.isEmptyString(fontFamily)) {
            int index = this._fontFamilyCombo.indexOf(fontFamily);
            if (index != -1) {
                this._fontFamilyCombo.select(index);
            } else {
                this._fontFamilyCombo.setText(fontFamily);
            }
        }
        if (!this.isEmptyString(fontSize = this._style.getFontSize())) {
            int index = this._fontSizeNumberCombo.indexOf(fontSize);
            if (index != -1) {
                this._fontSizeNumberCombo.select(index);
            } else {
                this._fontSizeNumberCombo.setText(fontSize);
            }
        }
        if (!this.isEmptyString(fontWeight = this._style.getFontWeight())) {
            int index = this._fontWeightCombo.indexOf(fontWeight);
            if (index != -1) {
                this._fontWeightCombo.select(index);
            } else {
                this._fontWeightCombo.setText(fontWeight);
            }
        }
        if (!this.isEmptyString(fontStyle = this._style.getFontStyle())) {
            int index = this._fontStyleCombo.indexOf(fontStyle);
            if (index != -1) {
                this._fontStyleCombo.select(index);
            } else {
                this._fontStyleCombo.setText(fontStyle);
            }
        }
        if (!this.isEmptyString(fontVariant = this._style.getFontVariant())) {
            int index = this._fontVariantCombo.indexOf(fontVariant);
            if (index != -1) {
                this._fontVariantCombo.select(index);
            } else {
                this._fontVariantCombo.setText(fontVariant);
            }
        }
        if (!this.isEmptyString(lineHeight = this._style.getLineHeight())) {
            int index = this._fontLineHeightNumberCombo.indexOf(lineHeight);
            if (index != -1) {
                this._fontLineHeightNumberCombo.select(index);
            } else {
                this._fontLineHeightNumberCombo.setText(lineHeight);
            }
        }
        if (!this.isEmptyString(textTransform = this._style.getTextTransform())) {
            int index = this._textTransformCombo.indexOf(textTransform);
            if (index != -1) {
                this._textTransformCombo.select(index);
            } else {
                this._textTransformCombo.setText(textTransform);
            }
        }
        if (!this.isEmptyString(textDecoration = this._style.getTextDecoration())) {
            int index = textDecoration.indexOf(IStyleConstants.TEXT_DECORATION[0]);
            if (index != -1) {
                this._textDecorationUnderlineButton.setSelection(true);
            } else {
                this._textDecorationUnderlineButton.setSelection(false);
            }
            index = textDecoration.indexOf(IStyleConstants.TEXT_DECORATION[1]);
            if (index != -1) {
                this._textDecorationOverlineButton.setSelection(true);
            } else {
                this._textDecorationOverlineButton.setSelection(false);
            }
            index = textDecoration.indexOf(IStyleConstants.TEXT_DECORATION[2]);
            if (index != -1) {
                this._textDecorationLineThroughButton.setSelection(true);
            } else {
                this._textDecorationLineThroughButton.setSelection(false);
            }
            index = textDecoration.indexOf(IStyleConstants.TEXT_DECORATION[3]);
            if (index != -1) {
                this._textDecorationBlinkButton.setSelection(true);
            } else {
                this._textDecorationBlinkButton.setSelection(false);
            }
            index = textDecoration.indexOf(IStyleConstants.TEXT_DECORATION[4]);
            if (index != -1) {
                this._textDecorationNoneButton.setSelection(true);
            } else {
                this._textDecorationNoneButton.setSelection(false);
            }
        }
        if (!this.isEmptyString(color = this._style.getColor())) {
            this._colorField.setTextWithoutUpdate(color);
        }
    }

    private String getTextDecoration() {
        StringBuffer textDecoration = new StringBuffer();
        if (this._textDecorationUnderlineButton.getSelection()) {
            textDecoration.append(this._textDecorationUnderlineButton.getText()).append(' ');
        }
        if (this._textDecorationOverlineButton.getSelection()) {
            textDecoration.append(this._textDecorationOverlineButton.getText()).append(' ');
        }
        if (this._textDecorationLineThroughButton.getSelection()) {
            textDecoration.append(this._textDecorationLineThroughButton.getText()).append(' ');
        }
        if (this._textDecorationBlinkButton.getSelection()) {
            textDecoration.append(this._textDecorationBlinkButton.getText()).append(' ');
        }
        if (this._textDecorationNoneButton.getSelection()) {
            textDecoration.append(this._textDecorationNoneButton.getText()).append(' ');
        }
        return textDecoration.toString().trim();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getApplyButton().setVisible(false);
        this.getDefaultsButton().setVisible(false);
    }

    private boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }
}

