/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.chrome;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.wildwebdeveloper.debug.chrome.ChromeExecutableTab;
import org.eclipse.wildwebdeveloper.debug.node.VSCodeJSDebugDelegate;

public class ChromeRunDAPDebugDelegate
extends VSCodeJSDebugDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.chromeRunDebug";
    public static final String URL = "url";

    public ChromeRunDAPDebugDelegate() {
        super("pwa-chrome");
    }

    @Override
    protected boolean configureAdditionalParameters(ILaunchConfiguration config, Map<String, Object> param) throws CoreException {
        if (super.configureAdditionalParameters(config, param)) {
            String program = (String)param.remove("program");
            param.put("file", program);
            return true;
        }
        return false;
    }

    @Override
    public File computeRuntimeExecutable(ILaunchConfiguration configuration) {
        String res = "";
        try {
            res = configuration.getAttribute("runtimeExecutable", res);
        }
        catch (CoreException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
        File executable = new File(res);
        if (executable.isAbsolute() && executable.canExecute()) {
            return executable;
        }
        return BrowserManager.getInstance().getWebBrowsers().stream().filter(ChromeExecutableTab::isChrome).findAny().map(IBrowserDescriptor::getLocation).map(File::new).orElse(null);
    }
}

