/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.operations.OCLExpressionOperations;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

public class PropertyCallExpOperations
extends OCLExpressionOperations {
    protected PropertyCallExpOperations() {
    }

    public static <C, P> boolean checkPropertyType(PropertyCallExp<C, P> propertyCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(propertyCallExp, context);
        if (env != null) {
            Object refType;
            P property = propertyCallExp.getReferredProperty();
            OCLExpression source = propertyCallExp.getSource();
            Object type = propertyCallExp.getType();
            if (property != null && source != null && !TypeUtil.exactTypeMatch(env, refType = TypeUtil.getPropertyType(env, source.getType(), property), type)) {
                result = false;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 33, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkPropertyType", EObjectValidator.getObjectLabel(propertyCallExp, context)}), new Object[]{propertyCallExp}));
        }
        return result;
    }
}

