/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.libhover;

import java.io.Serializable;
import java.util.ArrayList;

public class TypedefInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] templates = new String[0];
    private String typedefName;
    private String transformedType;
    private ArrayList<TypedefInfo> children = null;

    public TypedefInfo(String typedefName, String transformedType) {
        this.typedefName = typedefName;
        this.transformedType = transformedType;
    }

    public String getTypedefName() {
        return this.typedefName;
    }

    public void setTypedefName(String name) {
        this.typedefName = name;
    }

    private String[] getTemplateArgs(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int lastIndex = 0;
        int templateCounter = 0;
        for (int index = 0; index < str.length(); ++index) {
            char ch = str.charAt(index);
            if (ch == '<') {
                if (templateCounter == 0) {
                    lastIndex = index + 1;
                }
                ++templateCounter;
                continue;
            }
            if (ch == '>') {
                --templateCounter;
                continue;
            }
            if (ch != ',' || templateCounter != 1) continue;
            list.add(str.substring(lastIndex, index).trim());
            lastIndex = index + 1;
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public String getTransformedType(String className) {
        int index = className.indexOf(60);
        if (index > 0) {
            TypedefInfo e = this;
            ArrayList<TypedefInfo> children = this.getChildren();
            for (int x = 0; x < children.size(); ++x) {
                TypedefInfo child = children.get(x);
                if (!className.matches(child.getTypedefName())) continue;
                e = child;
                break;
            }
            String[] templates = e.getTemplates();
            String transformedName = e.transformedType;
            if (templates.length <= 0) {
                return transformedName;
            }
            String[] args = this.getTemplateArgs(className);
            String[] templateArgs = this.getTemplateArgs(e.getTypedefName());
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(templateArgs[i])) continue;
                transformedName = transformedName.replaceAll(templates[j], args[i]);
                ++j;
            }
            return transformedName;
        }
        return this.transformedType;
    }

    public void addTypedef(TypedefInfo typedef) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(typedef);
    }

    public ArrayList<TypedefInfo> getChildren() {
        return this.children;
    }

    public void copyTemplates(String[] newTemplates) {
        this.templates = new String[newTemplates.length];
        for (int i = 0; i < this.templates.length; ++i) {
            this.templates[i] = newTemplates[i];
        }
    }

    public String[] getTemplates() {
        return this.templates;
    }
}

