/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping4;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingUnitSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.UnitMappingTable;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class AuditListTableMappingWithRanges
extends AbstractBasicListTableMapping
implements IListMappingDeltaSupport,
IListMappingUnitSupport,
IListMapping4 {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AuditListTableMappingWithRanges.class);
    private static final int FINAL_VERSION = Integer.MAX_VALUE;
    private static final boolean CHECK_UNIT_ENTRIES = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.db.checkUnitEntries");
    private IDBTable table;
    private IDBField sourceField;
    private IDBField indexField;
    private IDBField versionAddedField;
    private IDBField versionRemovedField;
    private IDBField valueField;
    private AbstractHorizontalClassMapping classMapping;
    private ITypeMapping typeMapping;
    private String sqlSelectChunksPrefix;
    private String sqlSelectUnitEntries;
    private String sqlInsertEntry;
    private String sqlDeleteEntry;
    private String sqlRemoveEntry;
    private String sqlUpdateIndex;
    private String sqlGetValue;
    private String sqlClearList;
    private String sqlDeleteList;

    public AuditListTableMappingWithRanges(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        IDBStoreAccessor accessor = null;
        if (AbstractHorizontalMappingStrategy.isEagerTableCreation(mappingStrategy)) {
            accessor = (IDBStoreAccessor)StoreThreadLocal.getAccessor();
        }
        this.initTable(accessor);
    }

    private void initTable(IDBStoreAccessor accessor) {
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        this.typeMapping = this.getMappingStrategy().createValueMapping(this.getFeature());
        IDBStore store = this.getMappingStrategy().getStore();
        DBType idType = store.getIDHandler().getDBType();
        int idLength = store.getIDColumnLength();
        IDBDatabase database = this.getMappingStrategy().getStore().getDatabase();
        this.table = database.getSchema().getTable(tableName);
        if (this.table == null) {
            if (accessor != null) {
                try (IDBSchemaTransaction schemaTransaction = accessor.openSchemaTransaction();){
                    IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
                    IDBTable table = workingCopy.addTable(tableName);
                    this.sourceField = table.addField(MappingNames.LIST_REVISION_ID, idType, idLength, true);
                    this.versionAddedField = table.addField(MappingNames.LIST_REVISION_VERSION_ADDED, DBType.INTEGER);
                    this.versionRemovedField = table.addField(MappingNames.LIST_REVISION_VERSION_REMOVED, DBType.INTEGER);
                    this.indexField = table.addField(MappingNames.LIST_IDX, DBType.INTEGER, true);
                    table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.sourceField, this.versionAddedField, this.versionRemovedField, this.indexField});
                    this.typeMapping.createDBField(table, MappingNames.LIST_VALUE);
                    schemaTransaction.commit();
                }
                this.initTable(null);
                accessor.tableCreated(this.table);
            }
        } else {
            this.sourceField = this.table.getField(MappingNames.LIST_REVISION_ID);
            this.versionAddedField = this.table.getField(MappingNames.LIST_REVISION_VERSION_ADDED);
            this.versionRemovedField = this.table.getField(MappingNames.LIST_REVISION_VERSION_REMOVED);
            this.indexField = this.table.getField(MappingNames.LIST_IDX);
            this.typeMapping.setDBField(this.table, MappingNames.LIST_VALUE);
            this.valueField = this.table.getField(MappingNames.LIST_VALUE);
            this.initSQLStrings();
        }
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.valueField);
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.versionAddedField);
        builder.append("<=? AND (");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL OR ");
        builder.append(this.versionRemovedField);
        builder.append(">?)");
        this.sqlSelectChunksPrefix = builder.toString();
        builder = new StringBuilder("INSERT INTO ");
        builder.append(this.table);
        builder.append("(");
        builder.append(this.sourceField);
        builder.append(",");
        builder.append(this.versionAddedField);
        builder.append(",");
        builder.append(this.versionRemovedField);
        builder.append(",");
        builder.append(this.indexField);
        builder.append(",");
        builder.append(this.valueField);
        builder.append(") VALUES (?, ?, NULL, ?, ?)");
        this.sqlInsertEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.versionRemovedField);
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=? AND ");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL");
        this.sqlRemoveEntry = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=? AND ");
        builder.append(this.versionAddedField);
        builder.append("=?");
        this.sqlDeleteEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.indexField);
        builder.append("=? WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.versionAddedField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=?");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append(this.valueField);
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=? AND ");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL");
        this.sqlGetValue = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.versionRemovedField);
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL");
        this.sqlClearList = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.versionAddedField);
        builder.append("=? AND ");
        builder.append(this.versionRemovedField);
        builder.append(" IS NULL");
        this.sqlDeleteList = builder.toString();
    }

    @Override
    public void setClassMapping(IClassMapping classMapping) {
        this.classMapping = (AbstractHorizontalClassMapping)classMapping;
    }

    @Override
    public Collection<IDBTable> getDBTables() {
        return Collections.singleton(this.table);
    }

    @Override
    protected final IDBField index() {
        return this.indexField;
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final ITypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        if (this.table == null) {
            return;
        }
        CDOList list = revision.getListOrNull(this.getFeature());
        if (list == null) {
            return;
        }
        if (listChunk == 0 || list.size() == 0) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
        String sql = String.valueOf(this.sqlSelectChunksPrefix) + " ORDER BY " + this.indexField;
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
                stmt.setInt(2, revision.getVersion());
                stmt.setInt(3, revision.getVersion());
                if (listChunk != -1) {
                    stmt.setMaxRows(listChunk);
                }
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    Object value = this.typeMapping.readValue((ResultSet)resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{currentIndex, value});
                    }
                    list.set(currentIndex++, value);
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading {4} list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion(), list.size()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature() {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
        if (where != null) {
            builder.append(" AND ");
            builder.append(where);
        }
        builder.append(" ORDER BY " + this.indexField);
        String sql = builder.toString();
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = chunkReader.getAccessor().getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, chunkReader.getRevision().getID());
                stmt.setInt(2, chunkReader.getRevision().getVersion());
                stmt.setInt(3, chunkReader.getRevision().getVersion());
                resultSet = stmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    Object value = this.typeMapping.readValue((ResultSet)resultSet);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, value);
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature() {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, CDORevision revision, boolean firstRevision, boolean raw) {
        if (firstRevision || !raw) {
            this.writeValues(accessor, (InternalCDORevision)revision);
        } else {
            EStructuralFeature feature;
            InternalCDORevisionManager revisionManager = (InternalCDORevisionManager)this.getMappingStrategy().getStore().getRepository().getRevisionManager();
            InternalCDORevision baseRevision = revisionManager.getBaseRevision(revision, -1, true);
            CDOListFeatureDelta delta = CDORevisionUtil.compareLists((CDORevision)baseRevision, (CDORevision)revision, (EStructuralFeature)(feature = this.getFeature()));
            if (delta != null && !delta.getListChanges().isEmpty()) {
                int oldVersion = baseRevision.getVersion();
                int newVersion = revision.getVersion();
                this.processDelta(accessor, baseRevision, oldVersion, newVersion, delta.getListChanges());
            }
        }
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getListOrNull(this.getFeature());
        if (values != null && !values.isEmpty()) {
            if (this.table == null) {
                this.initTable(accessor);
            }
            int idx = 0;
            for (Object element : values) {
                this.writeValue(accessor, (CDORevision)revision, idx++, element);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Writing done", new Object[0]);
            }
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, revision.getID(), revision.getVersion(), value});
        }
        this.addEntry(accessor, revision.getID(), revision.getVersion(), index, value);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmtDeleteTemp = accessor.getDBConnection().prepareStatement(this.sqlDeleteList, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBPreparedStatement stmtClear = accessor.getDBConnection().prepareStatement(this.sqlClearList, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmtDeleteTemp, 1, id);
                stmtDeleteTemp.setInt(2, newVersion);
                int result = DBUtil.update((PreparedStatement)stmtDeleteTemp, (boolean)false);
                if (TRACER.isEnabled()) {
                    TRACER.format("DeleteList result: {0}", new Object[]{result});
                }
                stmtClear.setInt(1, newVersion);
                idHandler.setCDOID((PreparedStatement)stmtClear, 2, id);
                result = DBUtil.update((PreparedStatement)stmtClear, (boolean)false);
                if (TRACER.isEnabled()) {
                    TRACER.format("ClearList result: {0}", new Object[]{result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmtClear);
            DBUtil.close((Statement)stmtDeleteTemp);
        }
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        if (this.table == null) {
            this.initTable(accessor);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("objectRevised {0}: {1}", new Object[]{id, revised});
        }
        IRepository repository = this.getMappingStrategy().getStore().getRepository();
        CDOBranch main = repository.getBranchManager().getMainBranch();
        CDORevision revision = repository.getRevisionManager().getRevision(id, main.getHead(), 0, 0, true);
        this.clearList(accessor, id, revision.getVersion(), Integer.MAX_VALUE);
    }

    @Override
    public void rawDeleted(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version) {
        throw new UnsupportedOperationException("Raw deletion does not work in range-based mappings");
    }

    @Override
    public ResultSet queryUnitEntries(IDBStoreAccessor accessor, IIDHandler idHandler, long timeStamp, CDOID rootID) throws SQLException {
        if (this.sqlSelectUnitEntries == null) {
            DBStore store = (DBStore)this.getMappingStrategy().getStore();
            UnitMappingTable units = store.getUnitMappingTable();
            this.sqlSelectUnitEntries = "SELECT " + (CHECK_UNIT_ENTRIES ? this.classMapping.idField + ", " : "") + "cdo_list." + this.valueField + " FROM " + this.table + " cdo_list, " + this.classMapping.table + ", " + (Object)((Object)units) + " WHERE " + units.elem() + "=" + this.classMapping.idField + " AND " + this.classMapping.idField + "=cdo_list." + this.sourceField + " AND " + units.unit() + "=?" + " AND " + this.classMapping.createdField + "<=?" + " AND (" + this.classMapping.revisedField + "=0 OR " + this.classMapping.revisedField + ">=?)" + " AND cdo_list." + this.versionAddedField + "<=" + this.classMapping.versionField + " AND (cdo_list." + this.versionRemovedField + " IS NULL OR cdo_list." + this.versionRemovedField + ">" + this.classMapping.versionField + ") ORDER BY cdo_list." + this.sourceField + ", cdo_list." + this.indexField;
        }
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectUnitEntries, IDBPreparedStatement.ReuseProbability.MEDIUM);
        idHandler.setCDOID((PreparedStatement)stmt, 1, rootID);
        stmt.setLong(2, timeStamp);
        stmt.setLong(3, timeStamp);
        return stmt.executeQuery();
    }

    @Override
    public void readUnitEntries(ResultSet resultSet, IIDHandler idHandler, CDOID id, MoveableList<Object> list) throws SQLException {
        int size = list.size();
        int i = 0;
        while (i < size) {
            CDOID checkID;
            resultSet.next();
            if (CHECK_UNIT_ENTRIES && (checkID = idHandler.getCDOID(resultSet, 1)) != id) {
                throw new IllegalStateException("Result set does not deliver expected result");
            }
            Object value = this.typeMapping.readValue(resultSet);
            list.set(i, value);
            ++i;
        }
    }

    private void addEntry(IDBStoreAccessor accessor, CDOID id, int version, int index, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding value for feature() {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, version, value});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertEntry, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, version);
                stmt.setInt(column++, index);
                this.typeMapping.setValue((PreparedStatement)stmt, column++, value);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void removeEntry(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int index) {
        if (TRACER.isEnabled()) {
            TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlDeleteEntry, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, index);
                stmt.setInt(column++, newVersion);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (result == 1) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("removeEntry deleted: {0}", new Object[]{index});
                    }
                } else {
                    if (result > 1) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("removeEntry Too many results: {0}: {1}", new Object[]{index, result});
                        }
                        throw new DBException("Too many results");
                    }
                    DBUtil.close((Statement)stmt);
                    stmt = accessor.getDBConnection().prepareStatement(this.sqlRemoveEntry, IDBPreparedStatement.ReuseProbability.HIGH);
                    column = 1;
                    stmt.setInt(column++, newVersion);
                    idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                    stmt.setInt(column++, index);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
            }
            catch (SQLException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private Object getValue(IDBStoreAccessor accessor, CDOID id, int index) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlGetValue, IDBPreparedStatement.ReuseProbability.HIGH);
        Object result = null;
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, index);
                IDBResultSet resultSet = stmt.executeQuery();
                if (!resultSet.next()) {
                    throw new DBException("getValue() expects exactly one result");
                }
                result = this.typeMapping.readValue((ResultSet)resultSet);
                if (TRACER.isEnabled()) {
                    TRACER.format("Read value (index {0}) from result set: {1}", new Object[]{index, result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        return result;
    }

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        if (this.table == null) {
            return true;
        }
        String listJoin = this.getMappingStrategy().getListJoin("a_t", "l_t");
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT l_t.");
        builder.append(this.sourceField);
        builder.append(", l_t.");
        builder.append(this.valueField);
        builder.append(", l_t.");
        builder.append(this.indexField);
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" l_t, ");
        builder.append(mainTableName);
        builder.append(" a_t WHERE ");
        builder.append("a_t.");
        builder.append(mainTableWhere);
        builder.append(listJoin);
        builder.append(" AND ");
        builder.append(this.valueField);
        builder.append(" IN ");
        builder.append(idString);
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.format("Query XRefs (list): {0}", new Object[]{sql});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID sourceID = idHandler.getCDOID((ResultSet)resultSet, 1);
                CDOID targetID = idHandler.getCDOID((ResultSet)resultSet, 2);
                int idx = resultSet.getInt(3);
                boolean more = context.addXRef(targetID, sourceID, (EReference)this.getFeature(), idx);
                if (TRACER.isEnabled()) {
                    TRACER.format("  add XRef to context: src={0}, tgt={1}, idx={2}", new Object[]{sourceID, targetID, idx});
                }
                if (more) continue;
                if (TRACER.isEnabled()) {
                    TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
                }
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void processDelta(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        List listChanges = delta.getListChanges();
        if (listChanges.size() == 0) {
            return;
        }
        IRepository repository = accessor.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchPoint head = repository.getBranchManager().getMainBranch().getHead();
        InternalCDORevision originalRevision = (InternalCDORevision)revisionManager.getRevision(id, head, 0, 0, true);
        this.processDelta(accessor, originalRevision, oldVersion, newVersion, listChanges);
    }

    private void processDelta(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int oldVersion, int newVersion, List<CDOFeatureDelta> listChanges) {
        if (TRACER.isEnabled()) {
            int oldListSize = originalRevision.size(this.getFeature());
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        if (this.table == null) {
            this.initTable(accessor);
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor(accessor, originalRevision, oldVersion, newVersion);
        if (TRACER.isEnabled()) {
            TRACER.format("Processing deltas...", new Object[0]);
        }
        for (CDOFeatureDelta listDelta : listChanges) {
            listDelta.accept((CDOFeatureDeltaVisitor)visitor);
        }
        visitor.finishPendingRemove();
    }

    private class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private CDOID id;
        private int oldVersion;
        private int newVersion;
        private int lastIndex;
        private int lastRemovedIndex;

        public ListDeltaVisitor(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int oldVersion, int newVersion) {
            this.accessor = accessor;
            this.id = originalRevision.getID();
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.lastIndex = originalRevision.size(AuditListTableMappingWithRanges.this.getFeature()) - 1;
            this.lastRemovedIndex = -1;
        }

        public void visit(CDOMoveFeatureDelta delta) {
            boolean optimizeMove;
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            boolean bl = optimizeMove = this.lastRemovedIndex != -1 && fromIdx == this.lastIndex - 1 && toIdx == this.lastRemovedIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Moving: {0} to {1}", new Object[]{fromIdx, toIdx});
            }
            if (optimizeMove) {
                ++fromIdx;
            } else {
                this.finishPendingRemove();
            }
            Object value = AuditListTableMappingWithRanges.this.getValue(this.accessor, this.id, fromIdx);
            AuditListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, fromIdx);
            if (!optimizeMove) {
                if (fromIdx < toIdx) {
                    this.moveOneUp(this.accessor, this.id, this.oldVersion, this.newVersion, fromIdx + 1, toIdx);
                } else {
                    this.moveOneDown(this.accessor, this.id, this.oldVersion, this.newVersion, toIdx, fromIdx - 1);
                }
            } else {
                this.lastRemovedIndex = -1;
                --this.lastIndex;
            }
            AuditListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, toIdx, value);
        }

        public void visit(CDOAddFeatureDelta delta) {
            this.finishPendingRemove();
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Adding at: {0}", new Object[]{startIndex});
            }
            if (startIndex <= endIndex) {
                this.moveOneDown(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex, endIndex);
            }
            AuditListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, startIndex, delta.getValue());
            ++this.lastIndex;
        }

        public void visit(CDORemoveFeatureDelta delta) {
            this.finishPendingRemove();
            this.lastRemovedIndex = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Removing at: {0}", new Object[]{this.lastRemovedIndex});
            }
            AuditListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, this.lastRemovedIndex);
        }

        public void visit(CDOSetFeatureDelta delta) {
            this.finishPendingRemove();
            int index = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Setting at: {0}", new Object[]{index});
            }
            AuditListTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, index);
            AuditListTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, index, delta.getValue());
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Unsetting", new Object[0]);
            }
            AuditListTableMappingWithRanges.this.clearList(this.accessor, this.id, this.oldVersion, this.newVersion);
            this.lastIndex = -1;
            this.lastRemovedIndex = -1;
        }

        public void visit(CDOListFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Clearing", new Object[0]);
            }
            AuditListTableMappingWithRanges.this.clearList(this.accessor, this.id, this.oldVersion, this.newVersion);
            this.lastIndex = -1;
            this.lastRemovedIndex = -1;
        }

        public void visit(CDOContainerFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void finishPendingRemove() {
            if (this.lastRemovedIndex != -1) {
                int startIndex = this.lastRemovedIndex;
                int endIndex = this.lastIndex--;
                this.moveOneUp(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex + 1, endIndex);
                this.lastRemovedIndex = -1;
            }
        }

        private void moveOneUp(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = AuditListTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(AuditListTableMappingWithRanges.this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
            try {
                try {
                    int index = startIndex;
                    while (index <= endIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneUp moving: {0} -> {1}", new Object[]{index, index - 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index - 1);
                        idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 0: {
                                Object value = AuditListTableMappingWithRanges.this.getValue(accessor, id, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp remove: {0}", new Object[]{index});
                                }
                                AuditListTableMappingWithRanges.this.removeEntry(accessor, id, oldVersion, newVersion, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp add: {0}", new Object[]{index - 1});
                                }
                                AuditListTableMappingWithRanges.this.addEntry(accessor, id, newVersion, index - 1, value);
                                break;
                            }
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneUp updated: {0} -> {1}", new Object[]{index, index - 1});
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        ++index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        private void moveOneDown(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = AuditListTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(AuditListTableMappingWithRanges.this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
            try {
                try {
                    int index = endIndex;
                    while (index >= startIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneDown moving: {0} -> {1}", new Object[]{index, index + 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index + 1);
                        idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 0: {
                                Object value = AuditListTableMappingWithRanges.this.getValue(accessor, id, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown remove: {0}", new Object[]{index});
                                }
                                AuditListTableMappingWithRanges.this.removeEntry(accessor, id, oldVersion, newVersion, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown add: {0}", new Object[]{index + 1});
                                }
                                AuditListTableMappingWithRanges.this.addEntry(accessor, id, newVersion, index + 1, value);
                                break;
                            }
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneDown updated: {0} -> {1}", new Object[]{index, index + 1});
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        --index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }
    }
}

