/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.jobs.RepositoryJob;
import org.eclipse.egit.ui.internal.push.PushMode;
import org.eclipse.egit.ui.internal.push.ShowPushResultAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushJob
extends RepositoryJob {
    private final PushOperation operation;
    private final PushOperationResult resultToCompare;
    private final String destinationString;
    private final Repository localDb;
    private final boolean showConfigureButton;
    @NonNull
    private final PushMode pushMode;
    private PushOperationResult operationResult;

    public PushJob(String name, Repository repository, PushOperation operation, PushOperationResult expectedResult, String destinationString, boolean showConfigureButton, @NonNull PushMode pushMode) {
        super(name, "show_push_success_dialog");
        this.operation = operation;
        this.resultToCompare = expectedResult;
        this.destinationString = destinationString;
        this.localDb = repository;
        this.showConfigureButton = showConfigureButton;
        this.pushMode = pushMode;
    }

    @Override
    protected IStatus performJob(IProgressMonitor monitor) {
        try {
            this.operation.run(monitor);
        }
        catch (InvocationTargetException e) {
            return new Status(4, "org.eclipse.egit.ui", UIText.PushJob_unexpectedError, e.getCause());
        }
        this.operationResult = this.operation.getOperationResult();
        if (!this.operationResult.isSuccessfulConnectionForAnyURI()) {
            return new Status(4, "org.eclipse.egit.ui", NLS.bind((String)UIText.PushJob_cantConnectToAny, (Object)this.operationResult.getErrorStringForAllURis()));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IAction getAction() {
        Repository repo = this.localDb;
        if (!(repo == null || this.resultToCompare != null && this.resultToCompare.equals((Object)this.operationResult))) {
            return new ShowPushResultAction(repo, this.operationResult, this.destinationString, this.showConfigureButton, this.pushMode);
        }
        return null;
    }

    @Override
    protected IStatus getDeferredStatus() {
        for (URIish uri : this.operationResult.getURIs()) {
            PushResult outcome = this.operationResult.getPushResult(uri);
            for (RemoteRefUpdate update : outcome.getRemoteUpdates()) {
                switch (update.getStatus()) {
                    case NOT_ATTEMPTED: 
                    case UP_TO_DATE: 
                    case OK: {
                        break;
                    }
                    default: {
                        return new Status(4, "org.eclipse.egit.ui", 4, update.getMessage(), null);
                    }
                }
            }
        }
        return super.getDeferredStatus();
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.PUSH.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }
}

