/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.floatingpoint;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPMemoryByte;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPutilities;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.Rendering;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

class CopyAction
extends Action {
    private Rendering fRendering;
    private int fType = 1;

    public CopyAction(Rendering rendering) {
        this(rendering, 1);
    }

    public CopyAction(Rendering rendering, int clipboardType) {
        this.fType = clipboardType;
        this.fRendering = rendering;
        this.setText(DebugUIMessages.CopyViewToClipboardAction_title);
        this.setToolTipText(DebugUIMessages.CopyViewToClipboardAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_COPY_VIEW_TO_CLIPBOARD"));
    }

    public void run() {
        Clipboard clip = null;
        String PANE_SPACING = "  ";
        try {
            clip = new Clipboard(this.fRendering.getDisplay());
            BigInteger start = this.fRendering.getSelection().getStart();
            BigInteger end = this.fRendering.getSelection().getEnd();
            if (end == null) {
                return;
            }
            if (start.compareTo(end) > 0) {
                BigInteger bigI = end;
                end = start;
                start = bigI;
            }
            FPutilities.FPDataType numberType = this.fRendering.getFPDataType();
            int bytesPerColumn = numberType.getByteLength();
            boolean isLittleEndian = this.fRendering.isTargetLittleEndian();
            int columns = this.fRendering.getColumnCount();
            BigInteger lengthToRead = end.subtract(start);
            int rows = lengthToRead.divide(BigInteger.valueOf(columns * this.fRendering.getFPDataType().getByteLength())).intValue();
            if (rows * columns * bytesPerColumn < lengthToRead.intValue()) {
                ++rows;
            }
            StringBuilder buffer = new StringBuilder();
            int row = 0;
            while (row < rows) {
                BigInteger rowAddress = start.add(BigInteger.valueOf(row * columns * bytesPerColumn));
                if (this.fRendering.getPaneVisible(1)) {
                    buffer.append(this.fRendering.getAddressString(rowAddress));
                    buffer.append("  ");
                }
                if (this.fRendering.getPaneVisible(2)) {
                    int col = 0;
                    while (col < columns) {
                        BigInteger cellAddress = rowAddress.add(BigInteger.valueOf(col * bytesPerColumn));
                        if (cellAddress.compareTo(end) < 0) {
                            try {
                                FPMemoryByte[] bytes = this.fRendering.getBytes(cellAddress, bytesPerColumn);
                                buffer.append(this.fRendering.sciNotationString(bytes, numberType, isLittleEndian));
                            }
                            catch (DebugException de) {
                                this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_COPY_OPERATION"), (Exception)((Object)de));
                                if (clip != null) {
                                    clip.dispose();
                                }
                                return;
                            }
                        } else {
                            int i = this.fRendering.getCharsPerColumn();
                            while (i > 0) {
                                buffer.append(' ');
                                --i;
                            }
                        }
                        if (col != columns - 1) {
                            buffer.append(' ');
                        }
                        ++col;
                    }
                }
                if (this.fRendering.getPaneVisible(2)) {
                    buffer.append("  ");
                }
                buffer.append("\n");
                ++row;
            }
            if (buffer.length() > 0) {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                clip.setContents(new Object[]{buffer.toString()}, new Transfer[]{plainTextTransfer}, this.fType);
            }
        }
        finally {
            if (clip != null) {
                clip.dispose();
            }
        }
    }
}

