/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;

public class ContextWithShape {
    private final Resource[] dataGraph;
    private final Resource[] shapeGraph;
    private final Shape shape;

    public ContextWithShape(Resource[] dataGraph, Resource[] shapeGraph, Shape shape) {
        this.shapeGraph = shapeGraph;
        this.dataGraph = dataGraph;
        Arrays.sort(this.dataGraph, Comparator.comparing(v -> v != null ? v.stringValue() : "null"));
        Arrays.sort(this.shapeGraph, Comparator.comparing(v -> v != null ? v.stringValue() : "null"));
        this.shape = shape;
    }

    public Resource[] getShapeGraph() {
        return this.shapeGraph;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean hasShape() {
        return this.shape != null;
    }

    public Resource[] getDataGraph() {
        return this.dataGraph;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextWithShape that = (ContextWithShape)o;
        return Arrays.equals(this.dataGraph, that.dataGraph) && this.shape.equals(that.shape);
    }

    public int hashCode() {
        int result = this.shape.hashCode();
        result = 31 * result + Arrays.hashCode(this.dataGraph);
        return result;
    }

    public void toModel(Model model, Set<Resource> cycleDetection) {
        DynamicModel emptyModel = new DynamicModelFactory().createEmptyModel();
        this.shape.toModel(null, null, emptyModel, cycleDetection);
        for (Statement statement : emptyModel) {
            for (Resource context : this.shapeGraph) {
                model.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), context);
            }
        }
    }
}

