/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BasicQueryWriterSettings;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

abstract class AbstractSPARQLJSONWriter
extends AbstractQueryResultWriter
implements CharSink {
    private static final JsonFactory JSON_FACTORY = ((JsonFactoryBuilder)((JsonFactoryBuilder)((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).disable(StreamWriteFeature.AUTO_CLOSE_TARGET)).build();
    protected boolean firstTupleWritten = false;
    protected boolean documentOpen = false;
    protected boolean headerOpen = false;
    protected boolean headerComplete = false;
    protected boolean tupleVariablesFound = false;
    protected boolean linksFound = false;
    protected final JsonGenerator jg;
    private final Writer writer;

    protected AbstractSPARQLJSONWriter(OutputStream out) {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    protected AbstractSPARQLJSONWriter(Writer writer) {
        this.writer = writer;
        try {
            this.jg = JSON_FACTORY.createGenerator(writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final Writer getWriter() {
        return this.writer;
    }

    @Override
    public void endHeader() throws QueryResultHandlerException {
        if (!this.headerComplete) {
            try {
                this.jg.writeEndObject();
                if (this.tupleVariablesFound) {
                    this.jg.writeObjectFieldStart("results");
                    this.jg.writeArrayFieldStart("bindings");
                }
                this.headerComplete = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException(e);
            }
        }
    }

    @Override
    public void startQueryResult(List<String> columnHeaders) throws TupleQueryResultHandlerException {
        super.startQueryResult(columnHeaders);
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.tupleVariablesFound = true;
            this.jg.writeArrayFieldStart("vars");
            for (String nextColumn : columnHeaders) {
                this.jg.writeString(nextColumn);
            }
            this.jg.writeEndArray();
        }
        catch (IOException | QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    protected void handleSolutionImpl(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Must call startQueryResult before handleSolution");
            }
            this.firstTupleWritten = true;
            this.jg.writeStartObject();
            for (Binding binding : bindingSet) {
                this.jg.writeFieldName(binding.getName());
                this.writeValue(binding.getValue());
            }
            this.jg.writeEndObject();
        }
        catch (IOException | QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
            }
            this.jg.writeEndArray();
            this.jg.writeEndObject();
            this.endDocument();
        }
        catch (IOException | QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void startDocument() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.documentOpen = true;
            this.headerOpen = false;
            this.headerComplete = false;
            this.tupleVariablesFound = false;
            this.firstTupleWritten = false;
            this.linksFound = false;
            if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
                DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
                DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
                this.jg.setPrettyPrinter((PrettyPrinter)pp);
            }
            try {
                if (this.getWriterConfig().isSet(BasicQueryWriterSettings.JSONP_CALLBACK)) {
                    String callbackName = this.getWriterConfig().get(BasicQueryWriterSettings.JSONP_CALLBACK);
                    this.jg.writeRaw(callbackName);
                    this.jg.writeRaw("(");
                }
                this.jg.writeStartObject();
            }
            catch (IOException e) {
                throw new QueryResultHandlerException(e);
            }
        }
    }

    @Override
    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    @Override
    public void startHeader() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            try {
                this.jg.writeObjectFieldStart("head");
                this.headerOpen = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException(e);
            }
        }
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.jg.writeArrayFieldStart("link");
            for (String nextLink : linkUrls) {
                this.jg.writeString(nextLink);
            }
            this.jg.writeEndArray();
        }
        catch (IOException e) {
            throw new QueryResultHandlerException(e);
        }
    }

    protected void writeValue(Value value) throws IOException, QueryResultHandlerException {
        this.jg.writeStartObject();
        if (value instanceof IRI) {
            this.jg.writeStringField("type", "uri");
            this.jg.writeStringField("value", ((IRI)value).toString());
        } else if (value instanceof BNode) {
            this.jg.writeStringField("type", "bnode");
            this.jg.writeStringField("value", ((BNode)value).getID());
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (Literals.isLanguageLiteral(lit)) {
                this.jg.writeObjectField("xml:lang", lit.getLanguage().orElse(null));
            } else {
                boolean ignoreDatatype;
                IRI datatype = lit.getDatatype();
                boolean bl = ignoreDatatype = datatype.equals(XSD.STRING) && this.xsdStringToPlainLiteral();
                if (!ignoreDatatype) {
                    this.jg.writeObjectField("datatype", (Object)lit.getDatatype().stringValue());
                }
            }
            this.jg.writeObjectField("type", (Object)"literal");
            this.jg.writeObjectField("value", (Object)lit.getLabel());
        } else {
            throw new TupleQueryResultHandlerException("Unknown Value object type: " + value.getClass());
        }
        this.jg.writeEndObject();
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        if (!this.headerComplete) {
            this.endHeader();
        }
        if (this.tupleVariablesFound) {
            throw new QueryResultHandlerException("Cannot call handleBoolean after startQueryResults");
        }
        try {
            if (value) {
                this.jg.writeBooleanField("boolean", Boolean.TRUE.booleanValue());
            } else {
                this.jg.writeBooleanField("boolean", Boolean.FALSE.booleanValue());
            }
            this.endDocument();
        }
        catch (IOException e) {
            throw new QueryResultHandlerException(e);
        }
    }

    @Override
    public final Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicQueryWriterSettings.JSONP_CALLBACK);
        result.add(BasicWriterSettings.PRETTY_PRINT);
        return result;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }

    protected void endDocument() throws IOException {
        this.jg.writeEndObject();
        if (this.getWriterConfig().isSet(BasicQueryWriterSettings.JSONP_CALLBACK)) {
            this.jg.writeRaw(");");
        }
        this.jg.flush();
        this.documentOpen = false;
        this.headerOpen = false;
        this.headerComplete = false;
        this.tupleVariablesFound = false;
        this.firstTupleWritten = false;
        this.linksFound = false;
    }
}

