/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.setting;

import org.eclipse.rdf4j.console.setting.ConsoleSetting;

public class ConsoleWidth
extends ConsoleSetting<Integer> {
    public static final String NAME = "width";

    @Override
    public String getHelpLong() {
        return "set width=<number>             Set the width for query result tables\n";
    }

    public ConsoleWidth() {
        super(80);
    }

    public ConsoleWidth(Integer initValue) {
        super(initValue);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set(Integer value) throws IllegalArgumentException {
        int val = value;
        if (val <= 0) {
            throw new IllegalArgumentException("Width must be a positive integer");
        }
        super.set(val);
    }

    @Override
    public void setFromString(String value) throws IllegalArgumentException {
        try {
            this.set(Integer.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException();
        }
    }
}

