/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.oomph.internal.version.IVersionBuilderArguments;
import org.eclipse.oomph.internal.version.ReleaseManager;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IReleaseManager;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.ui.Activator;
import org.eclipse.oomph.version.ui.actions.AbstractAction;
import org.eclipse.oomph.version.ui.actions.Messages;
import org.eclipse.oomph.version.ui.dialogs.ConfigurationDialog;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class AddNatureAction
extends AbstractAction<IVersionBuilderArguments> {
    private static final String SRC_INCLUDES = "src.includes";

    public AddNatureAction() {
        super(Messages.AddNatureAction_jobName);
    }

    @Override
    protected IVersionBuilderArguments promptArguments() {
        ConfigurationDialog dialog;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (Object element : (IStructuredSelection)this.selection) {
            if (!(element instanceof IProject)) continue;
            projects.add((IProject)element);
        }
        ArrayList<IProject> basePlugins = new ArrayList<IProject>();
        ArrayList<IProject> baseFeatures = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.size()) {
            IProject project = (IProject)projects.get(i);
            List componentModels = VersionUtil.getComponentModels((IProject)project);
            Iterator iterator = componentModels.iterator();
            while (iterator.hasNext()) {
                IModel componentModel = (IModel)iterator.next();
                boolean dependenciesIncluded = false;
                IElement element = IReleaseManager.INSTANCE.createElement(componentModel, true, false);
                IElement.Type elementType = element.getType();
                if (elementType == IElement.Type.FEATURE || elementType == IElement.Type.PRODUCT) {
                    for (IElement child : element.getChildren()) {
                        IResource childComponentModelFile;
                        IModel childComponentModel = ReleaseManager.INSTANCE.getComponentModel(child);
                        if (childComponentModel == null || (childComponentModelFile = childComponentModel.getUnderlyingResource()) == null) continue;
                        IProject childProject = childComponentModelFile.getProject();
                        if (projects.contains(childProject)) {
                            dependenciesIncluded = true;
                            continue;
                        }
                        try {
                            if (childProject.hasNature("org.eclipse.oomph.version.VersionNature")) continue;
                            projects.add(childProject);
                            dependenciesIncluded = true;
                        }
                        catch (CoreException ex) {
                            Activator.log(ex);
                        }
                    }
                    if (dependenciesIncluded) continue;
                    baseFeatures.add(project);
                    continue;
                }
                IPluginBase pluginBase = ((IPluginModelBase)componentModel).getPluginBase();
                IPluginImport[] iPluginImportArray = pluginBase.getImports();
                int childComponentModelFile = iPluginImportArray.length;
                int childComponentModel = 0;
                while (childComponentModel < childComponentModelFile) {
                    IResource childComponentModelFile2;
                    String version;
                    IPluginImport pluginImport = iPluginImportArray[childComponentModel];
                    String importedPluginID = pluginImport.getId();
                    IPluginModelBase importedPlugin = AddNatureAction.findModel(importedPluginID, version = pluginImport.getVersion());
                    if (importedPlugin != null && (childComponentModelFile2 = importedPlugin.getUnderlyingResource()) != null) {
                        IProject childProject = childComponentModelFile2.getProject();
                        if (projects.contains(childProject)) {
                            dependenciesIncluded = true;
                        } else {
                            try {
                                if (!childProject.hasNature("org.eclipse.oomph.version.VersionNature")) {
                                    projects.add(childProject);
                                    dependenciesIncluded = true;
                                }
                            }
                            catch (CoreException ex) {
                                Activator.log(ex);
                            }
                        }
                    }
                    ++childComponentModel;
                }
                if (dependenciesIncluded) continue;
                basePlugins.add(project);
            }
            ++i;
        }
        IProject candidate = null;
        for (IProject project : basePlugins) {
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                candidate = project;
                break;
            }
            catch (CoreException ex) {
                Activator.log(ex);
            }
        }
        if (candidate == null) {
            if (!basePlugins.isEmpty()) {
                candidate = (IProject)basePlugins.get(0);
            } else if (!baseFeatures.isEmpty()) {
                candidate = (IProject)baseFeatures.get(0);
            }
        }
        this.selection = new StructuredSelection(projects);
        VersionBuilderArguments arguments = new VersionBuilderArguments();
        if (candidate != null) {
            arguments.setReleasePath("/" + candidate.getName() + "/release.xml");
        }
        if ((dialog = new ConfigurationDialog(this.shell, arguments)).open() == 0) {
            IModel componentModel;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(dialog.getReleasePath()));
            IProject project = file.getProject();
            if (project.isAccessible() && (componentModel = VersionUtil.getComponentModel((IProject)project)) instanceof IPluginModelBase) {
                try {
                    IBuild build;
                    IBuildModel buildModel = VersionUtil.getBuildModel((IModel)componentModel);
                    if (buildModel instanceof IEditableModel && (build = buildModel.getBuild()) != null) {
                        String releasePath;
                        IBuildEntry entry = build.getEntry(SRC_INCLUDES);
                        if (entry == null) {
                            entry = buildModel.getFactory().createEntry(SRC_INCLUDES);
                        }
                        String[] tokens = entry.getTokens();
                        HashSet<String> value = new HashSet<String>();
                        if (tokens != null) {
                            value.addAll(Arrays.asList(tokens));
                        }
                        if (!value.contains(releasePath = file.getProjectRelativePath().makeRelative().removeFileExtension().addFileExtension("*").toString())) {
                            entry.addToken(releasePath);
                            ((IEditableModel)buildModel).save();
                        }
                    }
                }
                catch (CoreException ex) {
                    Activator.log(ex);
                }
            }
            return dialog;
        }
        return null;
    }

    @Override
    protected void runWithArguments(IVersionBuilderArguments arguments) throws CoreException {
        for (Object element : (IStructuredSelection)this.selection) {
            if (!(element instanceof IProject)) continue;
            IProject project = (IProject)element;
            arguments.applyTo(project);
        }
    }

    private static IPluginModelBase findModel(String id, String version) {
        try {
            return PluginRegistry.findModel((String)id, (org.osgi.framework.VersionRange)new org.osgi.framework.VersionRange(version));
        }
        catch (NoSuchMethodError ex) {
            IPluginModelBase result = PluginRegistry.findModel((String)id, (VersionRange)new VersionRange(version), null);
            return result;
        }
    }
}

