/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;

public class ColumnLabelAccumulator
implements IConfigLabelProvider {
    private IDataProvider dataProvider;
    public static final String COLUMN_LABEL_PREFIX = "COLUMN_";

    public ColumnLabelAccumulator() {
    }

    public ColumnLabelAccumulator(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        configLabels.addLabel(COLUMN_LABEL_PREFIX + columnPosition);
    }

    @Override
    public Collection<String> getProvidedLabels() {
        HashSet<String> result = new HashSet<String>();
        if (this.dataProvider != null) {
            int i = 0;
            while (i < this.dataProvider.getColumnCount()) {
                result.add(COLUMN_LABEL_PREFIX + i);
                ++i;
            }
        }
        return result;
    }
}

