/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.command;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.AbstractContextFreeCommand;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class MultiColumnShowCommand
extends AbstractContextFreeCommand {
    private final int[] columnIndexes;

    public MultiColumnShowCommand(Collection<Integer> columnIndexes) {
        this.columnIndexes = columnIndexes.stream().mapToInt(Integer::intValue).toArray();
    }

    public MultiColumnShowCommand(int ... columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    public Collection<Integer> getColumnIndexes() {
        return ArrayUtil.asIntegerList(this.columnIndexes);
    }

    public int[] getColumnIndexesArray() {
        return this.columnIndexes;
    }

    @Override
    public MultiColumnShowCommand cloneCommand() {
        return new MultiColumnShowCommand(Arrays.copyOf(this.columnIndexes, this.columnIndexes.length));
    }
}

