/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AtlNbCharFile {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static final int ANTLR_TAB_WIDTH = 1;
    private List lines;

    public AtlNbCharFile(InputStream in) {
        this.computePosition(in);
    }

    private void computePosition(InputStream is) {
        this.lines = new ArrayList();
        try {
            int currentLineCharIndex = 0;
            int currentCharIndex = 0;
            int currentCharInLine = 0;
            int nbCharsSinceLastTab = 0;
            ArrayList<Integer> indexTabs = new ArrayList<Integer>();
            ArrayList<Integer> tabsWidth = new ArrayList<Integer>();
            while (true) {
                int currentChar;
                if ((char)(currentChar = is.read()) == '\n' || currentChar == -1) {
                    this.lines.add(new Line(currentLineCharIndex, indexTabs, tabsWidth));
                    currentLineCharIndex = currentCharIndex;
                    indexTabs = new ArrayList();
                    tabsWidth = new ArrayList();
                    currentCharInLine = -1;
                    nbCharsSinceLastTab = -1;
                    if (currentChar == -1) {
                        break;
                    }
                } else if ((char)currentChar == '\t') {
                    indexTabs.add(new Integer(currentCharInLine));
                    tabsWidth.add(new Integer(1 - nbCharsSinceLastTab % 1));
                    nbCharsSinceLastTab = -1;
                }
                ++currentCharIndex;
                ++currentCharInLine;
                ++nbCharsSinceLastTab;
            }
            this.lines.add(new Line(currentLineCharIndex, indexTabs, tabsWidth));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public int getIndexChar(int lineNumber, int column, int tabWidth) {
        int ret = 0;
        if (lineNumber != 1 || column != 1) {
            int indexOffset = 0;
            if (lineNumber > this.lines.size()) {
                return -1;
            }
            Line line = (Line)this.lines.get(lineNumber - 1);
            Iterator i = line.indexTabs.iterator();
            while (i.hasNext()) {
                int index = (Integer)i.next() + indexOffset;
                int actualTabWidth = tabWidth - index % tabWidth;
                if (column <= index) break;
                ret -= actualTabWidth - 1;
                indexOffset += actualTabWidth - 1;
            }
            ret += line.indexFirstChar + column + 1;
            if (lineNumber == 1) {
                --ret;
            }
        }
        return ret;
    }

    public int[] getIndexChar(String sourceLocation) {
        return this.getIndexChar(sourceLocation, 1);
    }

    public int[] getIndexChar(String sourceLocation, int tabWidth) {
        int[] ret = new int[2];
        if (tabWidth < 0) {
            tabWidth = 1;
        }
        String[] ss = sourceLocation.split("-");
        String[] starts = ss[0].split(":");
        int startLine = Integer.parseInt(starts[0]);
        int startColumn = Integer.parseInt(starts[1]) - 1;
        String[] ends = ss[1].split(":");
        int endLine = Integer.parseInt(ends[0]);
        int endColumn = Integer.parseInt(ends[1]) - 1;
        ret[0] = this.getIndexChar(startLine, startColumn, tabWidth);
        ret[1] = this.getIndexChar(endLine, endColumn, tabWidth);
        return ret;
    }

    public int getIndex(String cursorPosition) {
        int ret = 0;
        String[] starts = cursorPosition.split(":");
        int startLine = Integer.parseInt(starts[0].trim());
        int startColumn = Integer.parseInt(starts[1].trim()) - 1;
        ret = this.getIndexChar(startLine, startColumn, 4);
        return ret;
    }

    class Line {
        int indexFirstChar;
        List indexTabs;
        List tabsWidth;

        public Line(int indexFirstChar, List indexTabs, List tabsWidth) {
            this.indexFirstChar = indexFirstChar;
            this.indexTabs = indexTabs;
            this.tabsWidth = tabsWidth;
        }
    }
}

