/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Color;
import java.awt.Point;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;

public abstract class LMBadElement {
    public abstract int layoutAndReturnWidth(int var1);

    abstract AbsElement getGdeElement();

    static class Link
    extends LMBadElement {
        private final AbsLink myGdeLink;

        Link(AbsLink gdeLink) {
            this.myGdeLink = gdeLink;
        }

        public int layoutAndReturnWidth(int xPos) {
            this.myGdeLink.setForeground(Color.RED);
            this.myGdeLink.setLinkPoints(new Point[]{new Point(xPos + 5, 10), new Point(xPos + 5, 200)});
            return 10;
        }

        AbsElement getGdeElement() {
            return this.myGdeLink;
        }
    }

    static class Node
    extends LMBadElement {
        private final AbsNode myGdeNode;
        static final Color PROBLEM_COLOR = new Color(233, 60, 50);

        Node(AbsNode gdeNode) {
            this.myGdeNode = gdeNode;
        }

        public int layoutAndReturnWidth(int xPos) {
            this.myGdeNode.setBackground(PROBLEM_COLOR);
            if (this.myGdeNode.getWidth() < 30) {
                this.myGdeNode.setWidth(30);
            }
            if (this.myGdeNode.getHeight() < 40) {
                this.myGdeNode.setHeight(40);
            }
            return this.myGdeNode.getWidth();
        }

        AbsElement getGdeElement() {
            return this.myGdeNode;
        }
    }
}

