/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.horizontal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.ComparableVerticalElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.FramesManager;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.LifeLineDressImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.LifeLineHorizontalLayouter;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.LifelineCoveringFramesCache;
import org.eclipse.uml2.diagram.sequence.internal.layout.horizontal.UntiedFrameHorizontalLayouter;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMBadElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFoundInvocationOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrameContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutModelAccess;

public class SDHorizontalLayout {
    private LifelineCoveringFramesCache myLifelineCoverinngFramesCache;
    private final SdLayoutModelAccess myLayoutModelAccess;

    public SDHorizontalLayout(SdLayoutModelAccess layoutModelAccess) {
        this.myLayoutModelAccess = layoutModelAccess;
    }

    public LifelineCoveringFramesCache getLifelineCoveringFramesCache() {
        return this.myLifelineCoverinngFramesCache;
    }

    public int applyConstraints(int leftPos, boolean fullLayout) {
        List lmLifelinesNonsortedlList = this.myLayoutModelAccess.getLayoutModel().getLifeLinesList();
        ArrayList<LifeLineHorizontalLayouter> lifelineLayouters = new ArrayList<LifeLineHorizontalLayouter>(lmLifelinesNonsortedlList.size());
        for (Object nextLifeLineObject : lmLifelinesNonsortedlList) {
            if (!(nextLifeLineObject instanceof LMLifeLine)) continue;
            LMLifeLine lmLifeLine = (LMLifeLine)nextLifeLineObject;
            lifelineLayouters.add(new LifeLineHorizontalLayouter(lmLifeLine));
        }
        Collections.sort(lifelineLayouters, ComparableVerticalElement.COMPARATOR);
        FramesManager framesManager = new FramesManager(this.myLayoutModelAccess.getLayoutModel().getRootFrameContainer().getChildList());
        ArrayList<LifeLineHorizontalLayouter.PreparedLayout> preparedLayouts = new ArrayList<LifeLineHorizontalLayouter.PreparedLayout>(lifelineLayouters.size());
        ArrayList lmMessages = new ArrayList();
        int i = 0;
        while (i < lifelineLayouters.size()) {
            LifeLineHorizontalLayouter lifeLineHorizontalLayout = (LifeLineHorizontalLayouter)lifelineLayouters.get(i);
            framesManager.setLifeLineIndex(i);
            LifeLineHorizontalLayouter.PreparedLayout preparedLayout1 = lifeLineHorizontalLayout.scanAndPrepareLayout(framesManager, lmMessages);
            preparedLayouts.add(preparedLayout1);
            ++i;
        }
        this.myLifelineCoverinngFramesCache = new LifelineCoveringFramesCache();
        Iterator frameInfos = framesManager.frameInfos();
        while (frameInfos.hasNext()) {
            FramesManager.FrameInfo next = (FramesManager.FrameInfo)frameInfos.next();
            if (next.getMaxLifeLineIndex() == -1) continue;
            LMLifeLine leftmost = ((LifeLineHorizontalLayouter)lifelineLayouters.get(next.getMinLifeLineIndex())).getLmLifeline();
            LMLifeLine rightmost = ((LifeLineHorizontalLayouter)lifelineLayouters.get(next.getMaxLifeLineIndex())).getLmLifeline();
            this.myLifelineCoverinngFramesCache.setFrameOutermostLifelines(next.getLMFrame(), leftmost, rightmost);
        }
        LifeLineDressImpl[] lifeLineDresses = new LifeLineDressImpl[lifelineLayouters.size()];
        int i2 = 0;
        while (i2 < lifeLineDresses.length) {
            lifeLineDresses[i2] = new LifeLineDressImpl(fullLayout);
            ++i2;
        }
        int allLifeLinesLeftPos = 20 + leftPos;
        ArrayList foundMessages = new ArrayList(3);
        ArrayList topUntiedFrames = new ArrayList(0);
        class FramesAnalizer {
            private int myLeftIndex;
            private int myRightIndex;
            private boolean myOneJustReshapedFrameAlreadyProcessed = false;
            private final /* synthetic */ List val$topUntiedFrames;
            private final /* synthetic */ LifeLineDressImpl[] val$lifeLineDresses;
            private final /* synthetic */ FramesManager val$framesManager;
            private final /* synthetic */ boolean val$fullLayout;
            private final /* synthetic */ List val$foundMessages;

            FramesAnalizer(List list, LifeLineDressImpl[] lifeLineDressImplArray, FramesManager framesManager, boolean bl, List list2) {
                this.val$topUntiedFrames = list;
                this.val$lifeLineDresses = lifeLineDressImplArray;
                this.val$framesManager = framesManager;
                this.val$fullLayout = bl;
                this.val$foundMessages = list2;
            }

            public void go() {
                this.processFrameContainerRecursively(SDHorizontalLayout.this.myLayoutModelAccess.getLayoutModel().getRootFrameContainer(), this.val$topUntiedFrames);
            }

            private void processFrameContainerRecursively(LMFrameContainer frameContainer, Collection untiedFramesOutput) {
                List lmFramesList = frameContainer.getChildList();
                int leftLifeLineIndex = this.val$lifeLineDresses.length;
                int rigthLifeLineIndex = -1;
                int i = 0;
                while (i < lmFramesList.size()) {
                    LMFrame lmFrame = (LMFrame)lmFramesList.get(i);
                    if (lmFrame.hasAnyMountingLinks()) {
                        this.processFrameRecursively(lmFrame);
                    } else {
                        untiedFramesOutput.add(lmFrame);
                        this.myLeftIndex = this.val$lifeLineDresses.length;
                        this.myRightIndex = -1;
                    }
                    if (this.myLeftIndex < leftLifeLineIndex) {
                        leftLifeLineIndex = this.myLeftIndex;
                    }
                    if (this.myRightIndex > rigthLifeLineIndex) {
                        rigthLifeLineIndex = this.myRightIndex;
                    }
                    ++i;
                }
                this.myLeftIndex = leftLifeLineIndex;
                this.myRightIndex = rigthLifeLineIndex;
                this.collectFoundMessages(frameContainer);
            }

            private void processFrameRecursively(LMFrame lmFrame) {
                FramesManager.FrameInfo frameInfo = this.val$framesManager.getFrameInfo(lmFrame);
                ArrayList innerUntiedFrames = new ArrayList(0);
                boolean addAsJustReshaped = false;
                if (!this.val$fullLayout && lmFrame.isJustReshaped() && !this.myOneJustReshapedFrameAlreadyProcessed) {
                    addAsJustReshaped = true;
                    this.myOneJustReshapedFrameAlreadyProcessed = true;
                }
                this.processFrameContainerRecursively(lmFrame, innerUntiedFrames);
                if (this.myLeftIndex > frameInfo.getMinLifeLineIndex()) {
                    this.myLeftIndex = frameInfo.getMinLifeLineIndex();
                }
                if (this.myRightIndex < frameInfo.getMaxLifeLineIndex()) {
                    this.myRightIndex = frameInfo.getMaxLifeLineIndex();
                }
                UntiedFrameHorizontalLayouter untiedFrameLayouter = innerUntiedFrames.isEmpty() ? null : new UntiedFrameHorizontalLayouter(innerUntiedFrames);
                int maxLeftBracketOffset = this.myLeftIndex == frameInfo.getMinLifeLineIndex() ? frameInfo.getMaxLeftBraketPos() : 0;
                int maxRightBracketOffset = this.myRightIndex == frameInfo.getMaxLifeLineIndex() ? frameInfo.getMaxRightBraketPos() : 0;
                LifeLineDressImpl.LeftSideFrameWrapper leftSideOnTheSameLifeline = this.val$lifeLineDresses[this.myLeftIndex].addLeftFrame(lmFrame, maxLeftBracketOffset, untiedFrameLayouter, addAsJustReshaped);
                if (this.myLeftIndex != this.myRightIndex) {
                    leftSideOnTheSameLifeline = null;
                }
                this.val$lifeLineDresses[this.myRightIndex].addRightFrame(lmFrame, maxRightBracketOffset, addAsJustReshaped, leftSideOnTheSameLifeline);
            }

            private void collectFoundMessages(LMFrameContainer frameContainer) {
                for (LMFoundInvocationOccurence foundInvocationOccurence : frameContainer.getFoundInvocationsList()) {
                    this.val$foundMessages.addAll(foundInvocationOccurence.getOutgoingLMMessages());
                }
            }
        }
        new FramesAnalizer(topUntiedFrames, lifeLineDresses, framesManager, fullLayout, foundMessages).go();
        if (!topUntiedFrames.isEmpty()) {
            UntiedFrameHorizontalLayouter untiedFrameHorizontalLayouter = new UntiedFrameHorizontalLayouter(topUntiedFrames);
            untiedFrameHorizontalLayouter.layout(allLifeLinesLeftPos);
            allLifeLinesLeftPos += untiedFrameHorizontalLayouter.getWidth() + 20;
        }
        int posX = allLifeLinesLeftPos;
        int i3 = 0;
        while (i3 < preparedLayouts.size()) {
            LifeLineHorizontalLayouter.PreparedLayout preparedLayout1 = (LifeLineHorizontalLayouter.PreparedLayout)preparedLayouts.get(i3);
            int currentCenterPos = preparedLayout1.getCurrentCenterPos();
            int newCenterPos = posX + Math.max(preparedLayout1.getLeftHalfWidth(), lifeLineDresses[i3].getLeftMinSpace());
            if (!fullLayout && currentCenterPos > newCenterPos) {
                newCenterPos = currentCenterPos;
            }
            preparedLayout1.layout(newCenterPos);
            lifeLineDresses[i3].setMinLeftAndCenter(posX, newCenterPos);
            int maxRightPos = newCenterPos + Math.max(preparedLayout1.getRightHalfWidth(), lifeLineDresses[i3].getRightMinSpace());
            if (i3 + 1 < preparedLayouts.size()) {
                LifeLineHorizontalLayouter.PreparedLayout nextPreparedLayout = (LifeLineHorizontalLayouter.PreparedLayout)preparedLayouts.get(i3 + 1);
                int nextLifelineMinCurrentLeftPos = nextPreparedLayout.getCurrentCenterPos() - Math.max(nextPreparedLayout.getLeftHalfWidth(), lifeLineDresses[i3 + 1].getLeftMinSpace());
                maxRightPos = Math.max(maxRightPos, nextLifelineMinCurrentLeftPos - 20);
            } else {
                maxRightPos = Integer.MAX_VALUE;
            }
            lifeLineDresses[i3].setMaxRight(newCenterPos, maxRightPos);
            lifeLineDresses[i3].layout(newCenterPos);
            assert (lifeLineDresses[i3].getRightSpace() <= maxRightPos);
            posX = newCenterPos + Math.max(preparedLayout1.getRightHalfWidth(), lifeLineDresses[i3].getRightSpace()) + 20;
            ++i3;
        }
        int farAwayX = posX + 20;
        for (LMMessage message : lmMessages) {
            message.layoutHorizontally(fullLayout);
        }
        for (LMMessage message : foundMessages) {
            message.layoutHorizontally(fullLayout);
        }
        int badElementXPos = farAwayX;
        for (LMBadElement badElement : this.myLayoutModelAccess.getLayoutModel().getBadElementsList()) {
            int width = badElement.layoutAndReturnWidth(badElementXPos);
            badElementXPos += width + 5;
        }
        return badElementXPos;
    }
}

