/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdConfiguration
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdConfiguration.class);
    private static final String CONFIG_PATH = "/.well-known/openid-configuration";
    private final HttpClient httpClient;
    private final String issuer;
    private final String clientId;
    private final String clientSecret;
    private final List<String> scopes = new ArrayList<String>();
    private final String authMethod;
    private String authEndpoint;
    private String tokenEndpoint;

    public OpenIdConfiguration(String provider, String clientId, String clientSecret) {
        this(provider, null, null, clientId, clientSecret, null);
    }

    public OpenIdConfiguration(String issuer, String authorizationEndpoint, String tokenEndpoint, String clientId, String clientSecret, HttpClient httpClient) {
        this(issuer, authorizationEndpoint, tokenEndpoint, clientId, clientSecret, "client_secret_post", httpClient);
    }

    public OpenIdConfiguration(String issuer, String authorizationEndpoint, String tokenEndpoint, String clientId, String clientSecret, String authMethod, HttpClient httpClient) {
        this.issuer = issuer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authEndpoint = authorizationEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.httpClient = httpClient != null ? httpClient : OpenIdConfiguration.newHttpClient();
        this.authMethod = authMethod;
        if (this.issuer == null) {
            throw new IllegalArgumentException("Issuer was not configured");
        }
        this.addBean(this.httpClient);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.authEndpoint == null || this.tokenEndpoint == null) {
            Map<String, Object> discoveryDocument = OpenIdConfiguration.fetchOpenIdConnectMetadata(this.issuer, this.httpClient);
            this.authEndpoint = (String)discoveryDocument.get("authorization_endpoint");
            if (this.authEndpoint == null) {
                throw new IllegalArgumentException("authorization_endpoint");
            }
            this.tokenEndpoint = (String)discoveryDocument.get("token_endpoint");
            if (this.tokenEndpoint == null) {
                throw new IllegalArgumentException("token_endpoint");
            }
            if (!Objects.equals(discoveryDocument.get("issuer"), this.issuer)) {
                LOG.warn("The issuer in the metadata is not correct.");
            }
        }
    }

    private static HttpClient newHttpClient() {
        ClientConnector connector = new ClientConnector();
        connector.setSslContextFactory(new SslContextFactory.Client(false));
        return new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(connector));
    }

    private static Map<String, Object> fetchOpenIdConnectMetadata(String provider, HttpClient httpClient) {
        try {
            String responseBody;
            Object parsedResult;
            if (provider.endsWith("/")) {
                provider = provider.substring(0, provider.length() - 1);
            }
            if (!((parsedResult = new JSON().fromJSON(responseBody = httpClient.GET(provider + CONFIG_PATH).getContentAsString())) instanceof Map)) {
                LOG.warn("OpenID provider did not return a proper JSON object response. Result was '{}'", (Object)responseBody);
                throw new IllegalStateException("Could not parse OpenID provider's malformed response");
            }
            Map rawResult = (Map)parsedResult;
            Map<String, Object> result = rawResult.entrySet().stream().collect(Collectors.toMap(it -> it.getKey().toString(), Map.Entry::getValue));
            LOG.debug("discovery document {}", result);
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid identity provider", e);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void addScopes(String ... scopes) {
        if (scopes != null) {
            Collections.addAll(this.scopes, scopes);
        }
    }

    public List<String> getScopes() {
        return this.scopes;
    }
}

