/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server.proxy;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.StringUtil;

public class TryFilesFilter
implements Filter {
    public static final String FILES_INIT_PARAM = "files";
    private String[] files;

    public void init(FilterConfig config) throws ServletException {
        String param = config.getInitParameter(FILES_INIT_PARAM);
        if (param == null) {
            throw new ServletException(String.format("Missing mandatory parameter '%s'", FILES_INIT_PARAM));
        }
        this.files = param.split(" ");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        for (int i = 0; i < this.files.length - 1; ++i) {
            String file = this.files[i];
            String resolved = this.resolve(httpRequest, file);
            URL url = request.getServletContext().getResource(resolved);
            if (url == null || !Files.isReadable(this.toPath(url))) continue;
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        this.fallback(httpRequest, httpResponse, chain, this.files[this.files.length - 1]);
    }

    private Path toPath(URL url) throws IOException {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException x) {
            throw new IOException(x);
        }
    }

    protected void fallback(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String fallback) throws IOException, ServletException {
        String resolved = this.resolve(request, fallback);
        request.getServletContext().getRequestDispatcher(resolved).forward((ServletRequest)request, (ServletResponse)response);
    }

    private String resolve(HttpServletRequest request, String value) {
        Object path = request.getServletPath();
        String info = request.getPathInfo();
        if (info != null) {
            path = (String)path + info;
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return StringUtil.replace((String)value, (String)"$path", (String)path);
    }

    public void destroy() {
    }
}

