/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.tck.cdi.CDIBean;
import org.eclipse.microprofile.context.tck.contexts.buffer.Buffer;
import org.eclipse.microprofile.context.tck.contexts.label.Label;

@ApplicationScoped
public class CdiBeanProducer {
    @Produces
    @ApplicationScoped
    @CDIBean.LabelContextPropagator
    ThreadContext labelContextPropagator1 = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
    @Produces
    @ApplicationScoped
    @CDIBean.PriorityContext
    ThreadContext threadPriorityContext = ThreadContext.builder().propagated(new String[]{"ThreadPriority"}).build();

    @Produces
    @ApplicationScoped
    @CDIBean.AppProducedExecutor
    public ManagedExecutor createExec() {
        return ManagedExecutor.builder().cleared(new String[]{"Transaction"}).propagated(new String[]{"Remaining"}).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Produces
    @ApplicationScoped
    @CDIBean.Priority3Executor
    public Executor createPriority3Executor(@CDIBean.PriorityContext ThreadContext ctx) {
        int originalPriority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(3);
            Label.set("do-not-propagate-this-label");
            Buffer.set(new StringBuffer("do-not-propagate-this-buffer"));
            Executor executor = ctx.currentContextExecutor();
            return executor;
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }
}

